/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.silentchaos512.mechanisms.capability.EnergyStorageImpl;

public class EnergyStorageWithBatteries<T extends TileEntity>
extends EnergyStorageImpl {
    private final IInventory inventory;
    private final LazyOptional<EnergyStorageWithBatteries> lazy;
    protected int energyInternal;
    protected int capacityInternal;
    protected int maxReceive;
    protected int maxExtract;

    public EnergyStorageWithBatteries(T tileEntity, int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract, (TileEntity)tileEntity);
        this.inventory = (IInventory)tileEntity;
        this.capacityInternal = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.lazy = LazyOptional.of(() -> this);
    }

    public int getInternalEnergyStored() {
        return this.energyInternal;
    }

    private static boolean isBattery(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY).isPresent();
    }

    private int getBatteryCount() {
        int count = 0;
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (!EnergyStorageWithBatteries.isBattery(this.inventory.func_70301_a(i))) continue;
            ++count;
        }
        return count;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int batteryCount = this.getBatteryCount();
        int left = maxReceive;
        if (batteryCount > 0) {
            int perBattery = left / batteryCount;
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                LazyOptional optional = stack.getCapability(CapabilityEnergy.ENERGY);
                if (!optional.isPresent()) continue;
                left -= ((IEnergyStorage)optional.orElseThrow(IllegalStateException::new)).receiveEnergy(perBattery, simulate);
            }
        }
        int internalReceive = Math.min(this.capacityInternal - this.energyInternal, Math.min(this.maxReceive, left));
        if (!simulate) {
            this.energyInternal += internalReceive;
        }
        return maxReceive - (left - internalReceive);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int internalExtract = Math.min(this.energyInternal, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energyInternal -= internalExtract;
        }
        if (internalExtract >= maxExtract) {
            return internalExtract;
        }
        int batteryCount = this.getBatteryCount();
        int extracted = internalExtract;
        if (batteryCount > 0) {
            int perBattery = (maxExtract - internalExtract) / batteryCount;
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                LazyOptional optional = stack.getCapability(CapabilityEnergy.ENERGY);
                if (!optional.isPresent()) continue;
                extracted += ((IEnergyStorage)optional.orElseThrow(IllegalStateException::new)).extractEnergy(perBattery, simulate);
            }
        }
        return extracted;
    }

    public int extractInternalEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int internalExtract = Math.min(this.energyInternal, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energyInternal -= internalExtract;
        }
        return internalExtract;
    }

    public int getEnergyStored() {
        int ret = this.energyInternal;
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            LazyOptional optional = stack.getCapability(CapabilityEnergy.ENERGY);
            if (!optional.isPresent()) continue;
            ret += ((IEnergyStorage)optional.orElseThrow(IllegalStateException::new)).getEnergyStored();
        }
        return ret;
    }

    public int getMaxEnergyStored() {
        int ret = this.capacityInternal;
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            LazyOptional optional = stack.getCapability(CapabilityEnergy.ENERGY);
            if (!optional.isPresent()) continue;
            ret += ((IEnergyStorage)optional.orElseThrow(IllegalStateException::new)).getMaxEnergyStored();
        }
        return ret;
    }

    @Override
    public void setEnergyDirectly(int amount) {
        this.energyInternal = amount;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    @Nonnull
    public <S> LazyOptional<S> getCapability(@Nonnull Capability<S> cap, @Nullable Direction side) {
        return CapabilityEnergy.ENERGY.orEmpty(cap, this.lazy.cast());
    }
}

