/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.alloysmelter;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.mechanisms.block.AbstractMachineTileEntity;
import net.silentchaos512.mechanisms.block.alloysmelter.AlloySmelterContainer;
import net.silentchaos512.mechanisms.crafting.recipe.AlloySmeltingRecipe;
import net.silentchaos512.mechanisms.init.MachineType;
import net.silentchaos512.mechanisms.util.MachineTier;
import net.silentchaos512.mechanisms.util.TextUtil;

public class AlloySmelterTileEntity
extends AbstractMachineTileEntity<AlloySmeltingRecipe> {
    public static final int MAX_ENERGY = 50000;
    public static final int MAX_RECEIVE = 500;
    public static final int ENERGY_USED_PER_TICK = 30;
    static final int INPUT_SLOT_COUNT = 4;
    private static final int[] SLOTS_INPUT = IntStream.range(0, 4).toArray();
    private static final int[] SLOTS_OUTPUT = new int[]{4};
    private static final int[] SLOTS_ALL = IntStream.range(0, 5).toArray();

    public AlloySmelterTileEntity() {
        this(MachineTier.STANDARD);
    }

    public AlloySmelterTileEntity(MachineTier tier) {
        super(MachineType.ALLOY_SMELTER.getTileEntityType(tier), SLOTS_ALL.length, tier);
    }

    @Override
    protected int getEnergyUsedPerTick() {
        return 30;
    }

    @Override
    protected int[] getOutputSlots() {
        return SLOTS_OUTPUT;
    }

    @Override
    @Nullable
    protected AlloySmeltingRecipe getRecipe() {
        if (this.field_145850_b == null) {
            return null;
        }
        return this.field_145850_b.func_199532_z().func_215371_a(AlloySmeltingRecipe.RECIPE_TYPE, (IInventory)this, this.field_145850_b).orElse(null);
    }

    @Override
    protected int getProcessTime(AlloySmeltingRecipe recipe) {
        return recipe.getProcessTime();
    }

    @Override
    protected Collection<ItemStack> getProcessResults(AlloySmeltingRecipe recipe) {
        return Collections.singleton(recipe.getCraftingResult(this));
    }

    @Override
    protected void consumeIngredients(AlloySmeltingRecipe recipe) {
        recipe.consumeIngredients(this);
    }

    @Override
    public int getInputSlotCount() {
        return 4;
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.UP) {
            return SLOTS_INPUT;
        }
        if (side == Direction.DOWN) {
            return SLOTS_OUTPUT;
        }
        return SLOTS_ALL;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return index < 4;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 4;
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "alloy_smelter", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new AlloySmelterContainer(id, playerInventory, this, this.fields);
    }

    public static class Basic
    extends AlloySmelterTileEntity {
        public Basic() {
            super(MachineTier.BASIC);
        }
    }
}

