/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.mechanisms.block.IEnergyHandler;
import net.silentchaos512.mechanisms.capability.EnergyStorageImpl;
import net.silentchaos512.mechanisms.util.EnergyUtils;

public abstract class AbstractEnergyInventoryTileEntity
extends LockableSidedInventoryTileEntity
implements IEnergyHandler,
ITickableTileEntity {
    protected final EnergyStorageImpl energy;
    private final int maxExtract;
    private final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return AbstractEnergyInventoryTileEntity.this.getEnergyStored() & 0xFFFF;
                }
                case 1: {
                    return AbstractEnergyInventoryTileEntity.this.getEnergyStored() >> 16 & 0xFFFF;
                }
                case 2: {
                    return AbstractEnergyInventoryTileEntity.this.getMaxEnergyStored() & 0xFFFF;
                }
                case 3: {
                    return AbstractEnergyInventoryTileEntity.this.getMaxEnergyStored() >> 16 & 0xFFFF;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            AbstractEnergyInventoryTileEntity.this.getEnergyImpl().setEnergyDirectly(value);
        }

        public int func_221478_a() {
            return 4;
        }
    };

    protected AbstractEnergyInventoryTileEntity(TileEntityType<?> typeIn, int inventorySize, int maxEnergy, int maxReceive, int maxExtract) {
        super(typeIn, inventorySize);
        this.energy = new EnergyStorageImpl(maxEnergy, maxReceive, maxExtract, (TileEntity)this);
        this.maxExtract = maxExtract;
    }

    @Override
    public EnergyStorageImpl getEnergyImpl() {
        return this.energy;
    }

    public IIntArray getFields() {
        return this.fields;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.maxExtract > 0) {
            EnergyUtils.trySendToNeighbors((IBlockReader)this.field_145850_b, this.field_174879_c, this, this.maxExtract);
        }
    }

    public void func_145839_a(CompoundNBT tags) {
        super.func_145839_a(tags);
        SyncVariable.Helper.readSyncVars((Object)this, (CompoundNBT)tags);
        this.readEnergy(tags);
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        super.func_189515_b(tags);
        SyncVariable.Helper.writeSyncVars((Object)this, (CompoundNBT)tags, (SyncVariable.Type)SyncVariable.Type.WRITE);
        this.writeEnergy(tags);
        return tags;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        SyncVariable.Helper.readSyncVars((Object)this, (CompoundNBT)packet.func_148857_g());
        this.readEnergy(packet.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        SyncVariable.Helper.writeSyncVars((Object)this, (CompoundNBT)tags, (SyncVariable.Type)SyncVariable.Type.PACKET);
        this.writeEnergy(tags);
        return tags;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityEnergy.ENERGY) {
            return this.getEnergy(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.energy.invalidate();
    }
}

