/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.extrabuttons.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EntityPoweredRailBlock
extends PoweredRailBlock {
    public EntityPoweredRailBlock(Block.Properties builder) {
        super(builder);
    }

    public void onMinecartPass(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        if (!((Boolean)state.func_177229_b((IProperty)field_176569_M)).booleanValue()) {
            return;
        }
        if (!cart.shouldDoRailFunctions()) {
            return;
        }
        if (!cart.func_184207_aI()) {
            return;
        }
        RailShape railshape = this.getRailDirection(state, (IBlockReader)world, pos, cart);
        Vec3d motion = cart.func_213322_ci();
        double speed = Math.sqrt(AbstractMinecartEntity.func_213296_b((Vec3d)motion));
        if (speed > 0.01) {
            cart.func_213317_d(motion.func_72441_c(motion.field_72450_a / speed * 0.06, 0.0, motion.field_72449_c / speed * 0.06));
        } else {
            double motionX = motion.field_72450_a;
            double motionY = motion.field_72449_c;
            if (railshape == RailShape.EAST_WEST) {
                if (this.normalCube(world, pos.func_177976_e())) {
                    motionX = 0.02;
                } else if (this.normalCube(world, pos.func_177974_f())) {
                    motionX = -0.02;
                }
            } else if (railshape == RailShape.NORTH_SOUTH) {
                if (this.normalCube(world, pos.func_177978_c())) {
                    motionY = 0.02;
                } else if (this.normalCube(world, pos.func_177968_d())) {
                    motionY = -0.02;
                }
            } else {
                return;
            }
            cart.func_213293_j(motionX, motion.field_72448_b, motionY);
        }
    }

    private boolean normalCube(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_215686_e((IBlockReader)worldIn, pos);
    }
}

