/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.IBounds;
import com.endertech.common.IntBounds;
import java.util.function.Consumer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class WorldBounds {
    private final IntBounds x;
    private final IntBounds y;
    private final IntBounds z;

    public static WorldBounds from(IntBounds x, IntBounds y, IntBounds z) {
        return new WorldBounds(x, y, z);
    }

    public static WorldBounds from(BlockPos pos, int radius) {
        return WorldBounds.from(IntBounds.from(pos.func_177958_n()), IntBounds.from(pos.func_177956_o()), IntBounds.from(pos.func_177952_p())).extend(radius);
    }

    public static WorldBounds from(BlockPos pos1, BlockPos pos2) {
        return WorldBounds.from(IntBounds.from(pos1.func_177958_n(), pos2.func_177958_n()), IntBounds.from(pos1.func_177956_o(), pos2.func_177956_o()), IntBounds.from(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    public static WorldBounds vertPlane(BlockPos centerPos, int radius, Direction normal) {
        if (normal.func_176740_k().func_200128_b()) {
            return WorldBounds.from(centerPos, centerPos);
        }
        Direction facing = normal.func_176746_e();
        BlockPos from = new BlockPos((Vec3i)centerPos.func_177967_a(facing, -radius).func_177979_c(radius));
        BlockPos to = new BlockPos((Vec3i)centerPos.func_177967_a(facing, radius).func_177981_b(radius));
        WorldBounds bounds = WorldBounds.from(from, to);
        return bounds;
    }

    protected WorldBounds(IntBounds x, IntBounds y, IntBounds z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public IntBounds getX() {
        return this.x;
    }

    public IntBounds getZ() {
        return this.z;
    }

    public IntBounds getY() {
        return this.y;
    }

    public int getHeight() {
        return this.getY().length() + 1;
    }

    public boolean encloses(BlockPos pos) {
        return this.getX().encloses(pos.func_177958_n()) && this.getY().encloses(pos.func_177956_o()) && this.getZ().encloses(pos.func_177952_p());
    }

    public WorldBounds offset(int x, int y, int z) {
        return WorldBounds.from(this.getX().offset(x), this.getY().offset(y), this.getZ().offset(z));
    }

    public WorldBounds extend(int x, int y, int z) {
        return WorldBounds.from(this.getX().extend(x), this.getY().extend(y), this.getZ().extend(z));
    }

    public WorldBounds extend(int value) {
        return this.extend(value, value, value);
    }

    public WorldBounds extend(Direction facing, int value) {
        IBounds x = this.getX().offset(facing.func_82601_c() * value).unite((IBounds)this.getX());
        IBounds y = this.getY().offset(facing.func_96559_d() * value).unite((IBounds)this.getY());
        IBounds z = this.getZ().offset(facing.func_82599_e() * value).unite((IBounds)this.getZ());
        return WorldBounds.from((IntBounds)x, (IntBounds)y, (IntBounds)z);
    }

    public WorldBounds reduce(int x, int y, int z) {
        return WorldBounds.from(this.getX().reduce(x), this.getY().reduce(y), this.getZ().reduce(z));
    }

    public WorldBounds reduce(int value) {
        return this.reduce(value, value, value);
    }

    public BlockPos relative(BlockPos pos) {
        BlockPos min = this.min();
        return new BlockPos(pos.func_177958_n() - min.func_177958_n(), pos.func_177956_o() - min.func_177956_o(), pos.func_177952_p() - min.func_177952_p());
    }

    public boolean face(BlockPos pos) {
        return this.getX().corners(pos.func_177958_n()) || this.getY().corners(pos.func_177956_o()) || this.getZ().corners(pos.func_177952_p());
    }

    public boolean edge(BlockPos pos) {
        int result = 0;
        if (this.getX().corners(pos.func_177958_n())) {
            ++result;
        }
        if (this.getY().corners(pos.func_177956_o())) {
            ++result;
        }
        if (this.getZ().corners(pos.func_177952_p())) {
            ++result;
        }
        return result >= 2;
    }

    public boolean vertex(BlockPos pos) {
        return this.getX().corners(pos.func_177958_n()) && this.getY().corners(pos.func_177956_o()) && this.getZ().corners(pos.func_177952_p());
    }

    public void forEach(Consumer<? super BlockPos.Mutable> action) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int x : this.getX()) {
            for (int y : this.getY()) {
                for (int z : this.getZ()) {
                    pos.func_181079_c(x, y, z);
                    action.accept((BlockPos.Mutable)pos);
                }
            }
        }
    }

    public BlockPos min() {
        return new BlockPos(this.getX().getMin().intValue(), this.getY().getMin().intValue(), this.getZ().getMin().intValue());
    }

    public BlockPos max() {
        return new BlockPos(this.getX().getMax().intValue(), this.getY().getMax().intValue(), this.getZ().getMax().intValue());
    }

    public AxisAlignedBB toAABB() {
        return new AxisAlignedBB(this.min(), this.max());
    }
}

