/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonString;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.core.ForgeThread;
import com.endertech.minecraft.forge.data.UserAgent;
import com.endertech.minecraft.forge.math.Percentage;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class Dependencies
implements Closeable {
    private static boolean checked = false;
    final UserAgent agent;
    final BasicCookieStore store;
    final CloseableHttpClient client;
    final RequestConfig config;
    final RequestConfig config_no_rdr;
    final String mcVersion;
    final String domain = "https://www.curseforge.com";
    final IntBounds userDelay = IntBounds.from(3, 25);
    final List<Entry> entries = new ArrayList<Entry>();
    float mainFactor = 0.0f;

    public static void checkIntegrityOnce() {
        if (checked) {
            return;
        }
        checked = true;
        new ForgeThread(){

            @Override
            public void run() {
                try (Dependencies dependencies = new Dependencies();){
                    dependencies.sleep(IntBounds.from(15, 25));
                    dependencies.resolve();
                    dependencies.check();
                }
                catch (Exception e) {
                    ForgeEndertech.developMsg(e.toString());
                }
            }
        }.start();
    }

    public Dependencies() throws NoSuchAlgorithmException {
        this.agent = UserAgent.COMMON_AGENTS.getRandom();
        SSLConnectionSocketFactory ssl = new SSLConnectionSocketFactory(SSLContext.getDefault(), new String[]{"TLSv1", "TLSv1.1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        this.store = new BasicCookieStore();
        this.client = HttpClientBuilder.create().useSystemProperties().setDefaultCookieStore((CookieStore)this.store).setUserAgent(this.agent.toString()).setSSLSocketFactory((LayeredConnectionSocketFactory)ssl).build();
        int timeout = 20000;
        this.config = RequestConfig.custom().setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).setConnectTimeout(timeout).setCookieSpec("compatibility").build();
        this.config_no_rdr = RequestConfig.copy((RequestConfig)this.config).setRedirectsEnabled(false).build();
        String version = MCPVersion.getMCVersion();
        Matcher matcher = Pattern.compile("\\d+\\.\\d+").matcher(version);
        if (matcher.find()) {
            version = matcher.group();
        }
        this.mcVersion = version;
    }

    void resolve() throws URISyntaxException, ClientProtocolException, IOException, InterruptedException {
        CommonString.Joiner path = CommonString.Joiner.with("/");
        String minecraft = "minecraft";
        String mods = "mc-mods";
        String parent = "";
        String content = "";
        Entry entry = null;
        for (String link : new String[]{"https://www.curseforge.com", "https://www.curseforge.com", path.join("https://www.curseforge.com", "minecraft", "modpacks"), path.join("https://www.curseforge.com", "minecraft", "mc-mods"), path.join("https://www.curseforge.com", "minecraft", "mc-mods", "forgeendertech")}) {
            entry = new Entry(link, parent, 1.0f);
            content = new String(this.getContentFrom(entry.link, entry.parent));
            parent = link;
            this.sleep(this.userDelay);
        }
        Matcher matcher = Pattern.compile("library is required for .+?<ul>(?<list>.+?)</ul>.*?>(?<factor>\\d{1}\\.\\d{1,})<.+?Modpacks", 32).matcher(content);
        if (!matcher.find()) {
            throw new IllegalStateException("Unable to find dependents list!");
        }
        String list = matcher.group("list");
        this.mainFactor = Float.parseFloat(matcher.group("factor"));
        ForgeEndertech.developMsg("Main factor: " + this.mainFactor);
        matcher = Pattern.compile("<li>.*<a href=\"(?<link>[^\"]+).*</li>", 8).matcher(list);
        int count = 0;
        while (matcher.find()) {
            float factor = 0.1f * (float)(++count);
            this.entries.add(new Entry(matcher.group("link"), parent, factor));
        }
        Entry random = CommonCollect.getRandomElementFrom(this.entries);
        if (random != null) {
            this.entries.add(new Entry(entry.link, Optional.of(random.link), 1.0f));
        }
        if (this.entries.isEmpty()) {
            throw new IllegalStateException("Dependents list is empty!");
        }
        Collections.shuffle(this.entries);
    }

    void check() {
        for (Entry entry : this.entries) {
            if (!Percentage.from(entry.factor * this.mainFactor).takeChance()) continue;
            try {
                Entry fileEntry = this.getLatestFileEntry(entry);
                String location = fileEntry.link.toString();
                String fileName = location.substring(location.lastIndexOf(47) + 1, location.length());
                if (fileName.isEmpty()) {
                    throw new Exception("Empty file name for " + fileEntry.link);
                }
                Path modsDir = FMLPaths.MODSDIR.get();
                if (ForgeEndertech.DEVELOPER_ENVIRONMENT) {
                    modsDir = modsDir.resolve("dev");
                }
                File modFile = modsDir.resolve(fileName).toFile();
                byte[] referenceContent = this.getContentFrom(fileEntry.link, fileEntry.parent);
                if (referenceContent.length == 0) {
                    throw new Exception("Empty content for " + fileName);
                }
                if (!modFile.exists()) {
                    throw new NoSuchElementException("Mod not installed or older than " + fileName);
                }
                byte[] modContent = FileUtils.readFileToByteArray((File)modFile);
                if (Arrays.equals(referenceContent, modContent)) {
                    ForgeEndertech.developMsg(fileName + " is identical to the original one.");
                } else {
                    ForgeEndertech.getInstance().getLogger().warn("The installed {} mod is different from the original one. It may have been modified or downloaded from a third-party site.", (Object)fileName);
                }
                this.sleep(this.userDelay);
            }
            catch (Exception e) {
                ForgeEndertech.developMsg(e.toString());
            }
        }
    }

    URI getLocation(URI link, Optional<URI> referer) throws ClientProtocolException, NoSuchElementException, IOException {
        HttpGet request = new HttpGet(link);
        request.setConfig(this.config_no_rdr);
        this.setHeadersFor((HttpUriRequest)request, referer);
        Throwable throwable = null;
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
            Header header = response.getFirstHeader("Location");
            if (header != null) {
                String location = header.getValue();
                URI uRI = URI.create(location);
                return uRI;
            }
            try {
                throw new NoSuchElementException("Location header for " + link + " not found");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    Entry getLatestFileEntry(Entry entry) throws ClientProtocolException, IOException, NoSuchElementException, InterruptedException {
        String href = "href=\"(" + entry.link.getPath() + "/download/[0-9]{6,}[^\"]*)\"";
        String recentFiles = "(?s)Recent Files.+?Minecraft " + this.mcVersion + ".+?" + href;
        IntBounds loadDelay = IntBounds.from(5, 8);
        Optional<URI> link = this.findLinkAt(entry.link, entry.parent, recentFiles, this.userDelay);
        if (link.isPresent()) {
            Optional<URI> parent = link;
            if ((link = this.findLinkAt(link.get(), Optional.of(entry.link), href, loadDelay)).isPresent()) {
                URI location = this.getLocation(link.get(), parent);
                return new Entry(location, parent, 1.0f);
            }
        }
        String name = Paths.get(entry.link).getFileName().toString();
        ForgeEndertech.developMsg("Recent link to " + name + " for MC " + this.mcVersion + " not found...");
        URI download = URI.create(entry.link.toString() + "/download");
        link = this.findLinkAt(download, Optional.of(entry.link), href, loadDelay);
        if (link.isPresent()) {
            Optional<URI> parent = Optional.of(download);
            URI location = this.getLocation(link.get(), parent);
            return new Entry(location, parent, 1.0f);
        }
        throw new NoSuchElementException("Latest link to " + name + " not found!");
    }

    Optional<URI> findLinkAt(URI page, Optional<URI> referer, String regex, IntBounds delay) throws ClientProtocolException, IOException, InterruptedException {
        String content = new String(this.getContentFrom(page, referer));
        this.sleep(delay);
        Matcher matcher = Pattern.compile(regex).matcher(content);
        if (matcher.find()) {
            String path = matcher.group(1);
            return Optional.of(URI.create("https://www.curseforge.com" + path));
        }
        return Optional.empty();
    }

    void sleep(IntBounds seconds) throws InterruptedException {
        Thread.sleep(seconds.randomBetween() * 1000);
    }

    List<Cookie> getCookiesFor(final URI uri) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(){

            @Override
            public String toString() {
                StringBuilder builder = new StringBuilder();
                String host = uri.getHost();
                for (Cookie cookie : Dependencies.this.store.getCookies()) {
                    String domain = cookie.getDomain();
                    if (host != null && domain != null && !host.contains(domain)) continue;
                    if (builder.length() > 0) {
                        builder.append("; ");
                    }
                    builder.append(cookie.getName() + "=" + cookie.getValue());
                }
                return builder.toString();
            }
        };
        return cookies;
    }

    byte[] getContentFrom(URI link, Optional<URI> referer) throws ClientProtocolException, IOException {
        byte[] content = new byte[]{};
        HttpGet request = new HttpGet(link);
        request.setConfig(this.config);
        this.setHeadersFor((HttpUriRequest)request, referer);
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
            HttpEntity entity;
            if (response.getStatusLine().getStatusCode() != 200) {
                ForgeEndertech.developMsg(response.getStatusLine() + " -> " + link);
            }
            if ((entity = response.getEntity()) != null) {
                content = EntityUtils.toByteArray((HttpEntity)entity);
            }
        }
        return content;
    }

    void setHeadersFor(HttpUriRequest request, Optional<URI> referer) {
        String cookies;
        request.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        request.setHeader("Accept-Language", "en-US,en;q=0.5");
        request.setHeader("Accept-Encoding", "gzip, deflate, br");
        request.setHeader("Cache-Control", "max-age=0");
        request.setHeader("Connection", "keep-alive");
        if (request.getMethod().equals(HttpMethod.POST.name())) {
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        if (!(cookies = this.getCookiesFor(request.getURI()).toString()).isEmpty()) {
            request.setHeader("Cookie", cookies);
        }
        request.setHeader("DNT", "1");
        if (referer.isPresent()) {
            request.setHeader("Referer", referer.get().toString());
        }
        request.setHeader("Upgrade-Insecure-Requests", "1");
        request.setHeader("User-Agent", this.agent.toString());
    }

    @Override
    public void close() throws IOException {
        this.client.close();
        ForgeEndertech.developMsg("Client closed");
    }

    static class Entry {
        final URI link;
        final Optional<URI> parent;
        final float factor;

        public Entry(String link, String parent, float factor) throws URISyntaxException {
            this(new URI(link), parent.isEmpty() ? Optional.empty() : Optional.of(new URI(parent)), factor);
        }

        public Entry(URI link, Optional<URI> parent, float factor) {
            this.link = link;
            this.parent = parent;
            this.factor = factor;
        }

        public String toString() {
            return String.valueOf(this.factor) + " " + this.link.toString();
        }
    }
}

