/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.container.MarketClientContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class MarketFilterButton
extends Button {
    private static final ResourceLocation ICONS = new ResourceLocation("farmingforblockheads", "textures/gui/market.png");
    private final MarketClientContainer container;
    private final IMarketCategory category;
    private final List<String> tooltipLines = Lists.newArrayList();

    public MarketFilterButton(int x, int y, MarketClientContainer container, IMarketCategory category, Button.IPressable pressable) {
        super(x, y, 20, 20, "", pressable);
        this.container = container;
        this.category = category;
        this.tooltipLines.add(I18n.func_135052_a((String)this.category.getTooltipLangKey(), (Object[])new Object[0]));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        int texY = 14;
        if (this.container.getCurrentCategory() != null && this.container.getCurrentCategory() != this.category) {
            texY += 40;
        } else if (this.isHovered) {
            texY += 20;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ICONS);
        this.blit(this.x, this.y, 176, texY, this.width, this.height);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(this.category.getIconStack(), this.x + 2, this.y + 2);
    }

    public List<String> getTooltipLines() {
        return this.tooltipLines;
    }

    public IMarketCategory getCategory() {
        return this.category;
    }
}

