/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.block;

import com.catastrophe573.dimdungeons.block.BlockPortalKeyhole;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.command.CustomTeleporter;
import com.catastrophe573.dimdungeons.dimension.DungeonDimensionType;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class BlockGoldPortal
extends BreakableBlock {
    public static String REG_NAME = "block_gold_portal";

    public BlockGoldPortal() {
        super(Block.Properties.func_200945_a((Material)Material.field_151567_E).func_200943_b(50.0f).func_200947_a(SoundType.field_185853_f).func_200942_a().func_200951_a(15));
        this.setRegistryName("dimdungeons", REG_NAME);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!this.checkPortalIntegrity(state, (IWorld)worldIn, pos)) {
            worldIn.func_175655_b(pos, false);
        }
    }

    public void func_196242_c(BlockState stateIn, IWorld worldIn, BlockPos pos, int flags) {
        if (!this.checkPortalIntegrity(stateIn, worldIn, pos)) {
            worldIn.func_175655_b(pos, false);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.checkPortalIntegrity(stateIn, worldIn, currentPos)) {
            return stateIn;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public boolean func_220074_n(BlockState state) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            return;
        }
        if (!(entityIn instanceof ServerPlayerEntity)) {
            return;
        }
        if (entityIn.field_71088_bW > 0) {
            return;
        }
        if (entityIn.func_184218_aH()) return;
        if (entityIn.func_184207_aI()) return;
        if (!entityIn.func_184222_aU()) return;
        if (!entityIn.field_70122_E) return;
        TileEntityPortalKeyhole te = this.findKeyholeForThisPortal(state, (IWorld)worldIn, pos);
        if (te != null) {
            ItemStack item = te.getObjectInserted();
            if (item.func_190926_b()) return;
            if (item.func_77973_b() instanceof ItemPortalKey && worldIn.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
                ItemPortalKey key = (ItemPortalKey)item.func_77973_b();
                float warpX = key.getWarpX(item);
                float warpZ = key.getWarpZ(item);
                if (warpX != -1.0f && warpZ != -1.0f) {
                    this.actuallyPerformTeleport((ServerPlayerEntity)entityIn, DungeonDimensionType.getDimensionType(), warpX, 55.1, warpZ, 0.0);
                    return;
                }
                System.out.println("Player somehow used an unactivated key? Doing nothing.");
                return;
            }
            if (BlockGoldPortal.func_149634_a((Item)item.func_77973_b()) == null) return;
            return;
        } else {
            if (worldIn.func_201675_m().func_186058_p() != DungeonDimensionType.getDimensionType()) return;
            this.sendPlayerBackHome((ServerPlayerEntity)entityIn);
        }
    }

    protected void actuallyPerformTeleport(ServerPlayerEntity player, DimensionType dim, double x, double y, double z, double yaw) {
        player.field_71088_bW = 200;
        if (dim == DungeonDimensionType.getDimensionType()) {
            CustomTeleporter.teleportEntityToDimension(player, dim, false, x, y, z, 0.0f, 180.0f);
        } else {
            CustomTeleporter.teleportEntityToDimension(player, dim, false, x, y, z, player.func_189653_aC().field_189982_i, (float)yaw);
        }
    }

    protected void sendPlayerBackHome(ServerPlayerEntity player) {
        float lastX = 0.0f;
        float lastY = 0.0f;
        float lastZ = 0.0f;
        float lastYaw = player.func_189653_aC().field_189983_j;
        if (lastY < 2.0f) {
            BlockPos respawn = player.getBedLocation(DimensionType.field_223227_a_);
            if (respawn != null) {
                respawn.func_177982_a(0, 3, 0);
            } else {
                respawn = player.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_175694_M();
                respawn.func_177982_a(0, 2, 0);
            }
            lastX = respawn.func_177958_n();
            lastY = respawn.func_177956_o();
            lastZ = respawn.func_177952_p();
            lastYaw = player.func_189653_aC().field_189983_j;
        }
        this.actuallyPerformTeleport(player, DimensionType.field_223227_a_, lastX, lastY, lastZ, lastYaw);
    }

    public boolean checkPortalIntegrity(BlockState state, IWorld worldIn, BlockPos pos) {
        return worldIn.func_201675_m().func_186058_p() == DungeonDimensionType.getDimensionType() || this.isPortalShapeIntact(state, worldIn, pos);
    }

    private boolean isPortalShapeIntact(BlockState state, IWorld worldIn, BlockPos pos) {
        TileEntityPortalKeyhole te = this.findKeyholeForThisPortal(state, worldIn, pos);
        if (te == null) {
            return false;
        }
        if (!te.isActivated()) {
            return false;
        }
        BlockState keyholeBlock = worldIn.func_180495_p(te.func_174877_v());
        boolean frameLevel1 = false;
        frameLevel1 = keyholeBlock.func_177229_b((IProperty)BlockPortalKeyhole.FACING) == Direction.WEST || keyholeBlock.func_177229_b((IProperty)BlockPortalKeyhole.FACING) == Direction.EAST ? this.checkPortalFrameNorthSouth(worldIn, te.func_174877_v()) : this.checkPortalFrameWestEast(worldIn, te.func_174877_v());
        if (!frameLevel1) {
            return false;
        }
        ItemStack key = te.getObjectInserted();
        int keyLevel = ((ItemPortalKey)key.func_77973_b()).getKeyLevel(key);
        if (key.func_77973_b() instanceof ItemPortalKey && keyLevel >= 2) {
            boolean frameLevel2 = false;
            frameLevel2 = keyholeBlock.func_177229_b((IProperty)BlockPortalKeyhole.FACING) == Direction.WEST || keyholeBlock.func_177229_b((IProperty)BlockPortalKeyhole.FACING) == Direction.EAST ? this.checkPortalFrameLevel2NorthSouth(worldIn, te.func_174877_v()) : this.checkPortalFrameLevel2WestEast(worldIn, te.func_174877_v());
            if (!frameLevel2) {
                return false;
            }
        }
        return true;
    }

    private TileEntityPortalKeyhole findKeyholeForThisPortal(BlockState state, IWorld worldIn, BlockPos pos) {
        BlockPos p = pos.func_177984_a();
        for (int i = 0; i < 2; ++i) {
            BlockState keyhole = worldIn.func_180495_p(p);
            if (keyhole.func_177230_c() == BlockRegistrar.block_portal_keyhole) {
                return (TileEntityPortalKeyhole)worldIn.func_175625_s(p);
            }
            p = p.func_177984_a();
        }
        return null;
    }

    private boolean isValidPortalFrameBlock(Block b) {
        return b == Blocks.field_196696_di || b == Blocks.field_196700_dk || b == Blocks.field_196698_dj || b == Blocks.field_196702_dl;
    }

    private boolean checkPortalFrameWestEast(IWorld worldIn, BlockPos keyhole) {
        if (!(this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177976_e().func_177977_b()).func_177230_c()) && this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177976_e().func_177979_c(2)).func_177230_c()) && this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177974_f().func_177977_b()).func_177230_c()) && this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177974_f().func_177979_c(2)).func_177230_c()) && this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177979_c(3)).func_177230_c()))) {
            return false;
        }
        if (worldIn.func_180495_p(keyhole.func_177985_f(3).func_177979_c(1)).func_177230_c() != BlockRegistrar.block_gilded_portal || !this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177985_f(3).func_177979_c(2)).func_177230_c()) || !this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177985_f(3).func_177979_c(3)).func_177230_c())) {
            return false;
        }
        return worldIn.func_180495_p(keyhole.func_177965_g(3).func_177979_c(1)).func_177230_c() == BlockRegistrar.block_gilded_portal && this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177965_g(3).func_177979_c(2)).func_177230_c()) && this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177965_g(3).func_177979_c(3)).func_177230_c());
    }

    private boolean checkPortalFrameNorthSouth(IWorld worldIn, BlockPos keyhole) {
        if (!(this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177978_c().func_177977_b()).func_177230_c()) && this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177978_c().func_177979_c(2)).func_177230_c()) && this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177968_d().func_177977_b()).func_177230_c()) && this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177968_d().func_177979_c(2)).func_177230_c()) && this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177979_c(3)).func_177230_c()))) {
            return false;
        }
        if (worldIn.func_180495_p(keyhole.func_177964_d(3).func_177979_c(1)).func_177230_c() != BlockRegistrar.block_gilded_portal || !this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177964_d(3).func_177979_c(2)).func_177230_c()) || !this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177964_d(3).func_177979_c(3)).func_177230_c())) {
            return false;
        }
        return worldIn.func_180495_p(keyhole.func_177970_e(3).func_177979_c(1)).func_177230_c() == BlockRegistrar.block_gilded_portal && this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177970_e(3).func_177979_c(2)).func_177230_c()) && this.isValidPortalFrameBlock(worldIn.func_180495_p(keyhole.func_177970_e(3).func_177979_c(3)).func_177230_c());
    }

    private boolean checkPortalFrameLevel2WestEast(IWorld worldIn, BlockPos keyhole) {
        if (worldIn.func_180495_p(keyhole.func_177985_f(1)).func_177230_c() != BlockRegistrar.block_portal_crown || worldIn.func_180495_p(keyhole.func_177965_g(1)).func_177230_c() != BlockRegistrar.block_portal_crown) {
            return false;
        }
        int front = this.getBannerLevel(worldIn, keyhole.func_177985_f(3).func_177979_c(1).func_177964_d(1));
        int back = this.getBannerLevel(worldIn, keyhole.func_177985_f(3).func_177979_c(1).func_177970_e(1));
        if (front < 2 && back < 2) {
            return false;
        }
        front = this.getBannerLevel(worldIn, keyhole.func_177965_g(3).func_177979_c(1).func_177964_d(1));
        back = this.getBannerLevel(worldIn, keyhole.func_177965_g(3).func_177979_c(1).func_177970_e(1));
        return front >= 2 || back >= 2;
    }

    private boolean checkPortalFrameLevel2NorthSouth(IWorld worldIn, BlockPos keyhole) {
        if (worldIn.func_180495_p(keyhole.func_177964_d(1)).func_177230_c() != BlockRegistrar.block_portal_crown || worldIn.func_180495_p(keyhole.func_177970_e(1)).func_177230_c() != BlockRegistrar.block_portal_crown) {
            return false;
        }
        int front = this.getBannerLevel(worldIn, keyhole.func_177964_d(3).func_177979_c(1).func_177985_f(1));
        int back = this.getBannerLevel(worldIn, keyhole.func_177964_d(3).func_177979_c(1).func_177965_g(1));
        if (front < 2 && back < 2) {
            return false;
        }
        front = this.getBannerLevel(worldIn, keyhole.func_177970_e(3).func_177979_c(1).func_177985_f(1));
        back = this.getBannerLevel(worldIn, keyhole.func_177970_e(3).func_177979_c(1).func_177965_g(1));
        return front >= 2 || back >= 2;
    }

    public int getBannerLevel(IWorld worldIn, BlockPos pos) {
        boolean level2 = false;
        boolean level3 = false;
        Block banner = worldIn.func_180495_p(pos).func_177230_c();
        if (banner != Blocks.field_196843_hj && banner != Blocks.field_196863_ht) {
            return 0;
        }
        BannerTileEntity te = (BannerTileEntity)worldIn.func_175625_s(pos);
        if (te == null) {
            return 0;
        }
        List patterns = null;
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            patterns = te.func_175114_c();
        } else {
            Object tempList = ObfuscationReflectionHelper.getPrivateValue(BannerTileEntity.class, (Object)te, (String)"field_175118_f");
            ListNBT nbt = (ListNBT)tempList;
            if (nbt == null) {
                return 0;
            }
            patterns = Lists.newArrayList();
            for (int i = 0; i < nbt.size(); ++i) {
                CompoundNBT compoundnbt = nbt.func_150305_b(i);
                BannerPattern bannerpattern = BlockGoldPortal.getBannerForHash(compoundnbt.func_74779_i("Pattern"));
                if (bannerpattern == null) continue;
                int j = compoundnbt.func_74762_e("Color");
                patterns.add(Pair.of((Object)bannerpattern, (Object)DyeColor.func_196056_a((int)j)));
            }
        }
        for (int i = 0; i < patterns.size(); ++i) {
            Pair p = (Pair)patterns.get(i);
            if (banner == Blocks.field_196843_hj && p.getFirst() == BannerPattern.DIAGONAL_RIGHT && p.getSecond() == DyeColor.PURPLE) {
                level2 = true;
            }
            if (banner != Blocks.field_196863_ht || p.getFirst() != BannerPattern.DIAGONAL_LEFT || p.getSecond() != DyeColor.WHITE) continue;
            level2 = true;
        }
        if (level2 && level3) {
            return 3;
        }
        if (level2) {
            return 2;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (float)pos.func_177958_n() + rand.nextFloat();
        double d1 = (float)pos.func_177956_o() + 0.8f;
        double d2 = (float)pos.func_177952_p() + rand.nextFloat();
        double xspeed = rand.nextFloat() * (float)(rand.nextInt(3) - 1) / 9.0f;
        double zspeed = rand.nextFloat() * (float)(rand.nextInt(3) - 1) / 9.0f;
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197624_q, d0, d1, d2, xspeed, 0.0, zspeed);
    }

    public static BannerPattern getBannerForHash(String hash) {
        for (BannerPattern bannerpattern : BannerPattern.values()) {
            if (!bannerpattern.func_190993_b().equals(hash)) continue;
            return bannerpattern;
        }
        return null;
    }
}

