/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network;

import java.util.function.Predicate;
import journeymap.common.Journeymap;
import journeymap.common.network.impl.NetworkHandler;
import journeymap.common.version.Version;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkRegistry;

public class PacketRegistry {
    private static PacketRegistry INSTANCE;
    private static final Version MINIMUM_SERVER_ACCEPTABLE_VERSION;
    private static final Version MINIMUM_CLIENT_ACCEPTABLE_VERSION;

    public static void init() {
        INSTANCE = new PacketRegistry();
        NetworkHandler handler = new NetworkHandler("journeymap", Journeymap.JM_VERSION.toMajorMinorString(), PacketRegistry.getServerAcceptedVersion(), PacketRegistry.getClientAcceptedVersion());
        handler.register();
    }

    private static Predicate<String> getClientAcceptedVersion() {
        return server -> {
            if (server.equalsIgnoreCase(NetworkRegistry.ABSENT) || server.equalsIgnoreCase(NetworkRegistry.ACCEPTVANILLA)) {
                return true;
            }
            if ("1.0".equalsIgnoreCase(Version.from(server, null).toMajorMinorString())) {
                Journeymap.getLogger().info("Dev Mode?");
                return true;
            }
            if (MINIMUM_SERVER_ACCEPTABLE_VERSION.isNewerThan(Version.from(server, null))) {
                Journeymap.getLogger().info("Version Mismatch need " + MINIMUM_SERVER_ACCEPTABLE_VERSION.toString() + " or higher. Current version attempt -> " + Version.from(server, null).toMajorMinorString());
                return false;
            }
            return true;
        };
    }

    private static Predicate<String> getServerAcceptedVersion() {
        return client -> {
            if (client.equalsIgnoreCase(NetworkRegistry.ABSENT) || client.equalsIgnoreCase(NetworkRegistry.ACCEPTVANILLA)) {
                return true;
            }
            if ("1.0".equalsIgnoreCase(Version.from(client, null).toMajorMinorString())) {
                Journeymap.getLogger().info("Dev Mode?");
                return true;
            }
            if (MINIMUM_CLIENT_ACCEPTABLE_VERSION.isNewerThan(Version.from(client, null))) {
                Journeymap.getLogger().info("Version Mismatch need " + MINIMUM_CLIENT_ACCEPTABLE_VERSION.toString() + " or higher. Current version attempt -> " + Version.from(client, null).toMajorMinorString());
                return false;
            }
            return true;
        };
    }

    public static PacketRegistry getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Journeymap.getLogger().error("Packet Handler not initialized before use.");
        throw new UnsupportedOperationException("Packet Handler not Initialized");
    }

    public void versionMismatch() {
        try {
            StringTextComponent text1 = new StringTextComponent("Disabling Journeymap for this server.");
            StringTextComponent text2 = new StringTextComponent("This client cannot connect to servers running versions older than Journeymap 5.5.5");
            StringTextComponent text3 = new StringTextComponent("Please downgrade to Journeymap 5.5.4 to connect to this server or ask the server admin to update Journeymap.");
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)text1);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)text2);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)text3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Journeymap.getClient().disable();
    }

    static {
        MINIMUM_SERVER_ACCEPTABLE_VERSION = new Version(5, 7, 0);
        MINIMUM_CLIENT_ACCEPTABLE_VERSION = new Version(5, 7, 0);
    }
}

