/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import journeymap.client.ui.component.OnOffButton;
import journeymap.client.ui.waypoint.WaypointManagerItem;
import net.minecraft.client.gui.widget.button.Button;

class SortButton
extends OnOffButton {
    final WaypointManagerItem.Sort sort;
    final String labelInactive;

    public SortButton(String label, WaypointManagerItem.Sort sort, Button.IPressable onPress) {
        super(String.format("%s %s", label, "\u25b2"), String.format("%s %s", label, "\u25bc"), sort.ascending, onPress);
        this.labelInactive = label;
        this.sort = sort;
    }

    @Override
    public void toggle() {
        this.sort.ascending = !this.sort.ascending;
        this.setActive(true);
    }

    @Override
    public void render(int mouseX, int mouseY, float f) {
        super.render(mouseX, mouseY, f);
        super.drawUnderline();
    }

    public void setActive(boolean active) {
        if (active) {
            this.setToggled(this.sort.ascending);
        } else {
            this.setMessage(String.format("%s %s", this.labelInactive, " "));
        }
    }
}

