/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.draw.DrawUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class MatrixDrawUtil {
    public static int zLevel = 0;

    public static void drawColoredImage(NativeImage texture, MatrixStack stack, IVertexBuilder vertexBuilder, int color, float alpha, double x, double y, double rotation) {
        MatrixDrawUtil.drawQuad(stack, vertexBuilder, color, alpha, x, y, texture.func_195702_a(), texture.func_195714_b(), false, rotation);
    }

    public static void drawQuad(MatrixStack stack, IVertexBuilder vertexBuilder, int color, float alpha, double x, double y, double width, double height, boolean flip, double rotation) {
        MatrixDrawUtil.drawQuad(stack, vertexBuilder, color, alpha, x, y, width, height, 0.0, 0.0, 1.0, 1.0, rotation, flip, true, 770, 771, false);
    }

    public static void drawLabel(String text, MatrixStack stack, IRenderTypeBuffer buffers, double x, double y, DrawUtil.HAlign hAlign, DrawUtil.VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow) {
        double bgWidth = 0.0;
        double bgHeight = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            bgWidth = fontRenderer.func_78256_a(text);
            bgHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        }
        MatrixDrawUtil.drawLabel(text, stack, buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, 0);
    }

    private static void drawLabel(String text, MatrixStack stack, IRenderTypeBuffer buffers, double x, double y, DrawUtil.HAlign hAlign, DrawUtil.VAlign vAlign, Integer bgColor, float bgAlpha, double bgWidth, double bgHeight, int color, float alpha, double fontScale, boolean fontShadow, int rotation) {
        double d;
        int height;
        int n;
        if (text == null || text.length() == 0) {
            return;
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        boolean drawRect = bgColor != null && bgAlpha > 0.0f;
        double width = fontRenderer.func_78256_a(text);
        if (drawRect) {
            n = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        } else {
            fontRenderer.getClass();
            n = height = 9;
        }
        if (!drawRect && fontRenderer.func_78260_a()) {
            --height;
        }
        stack.func_227860_a_();
        if (fontScale != 1.0) {
            x /= fontScale;
            y /= fontScale;
            stack.func_227862_a_((float)fontScale, (float)fontScale, 0.0f);
        }
        float textX = (float)x;
        float textY = (float)y;
        double rectX = x;
        double rectY = y;
        switch (hAlign) {
            case Left: {
                textX = (float)(x - width);
                rectX = textX;
                break;
            }
            case Center: {
                textX = (float)(x - width / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                rectX = (float)(x - Math.max(1.0, bgWidth) / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                break;
            }
            case Right: {
                textX = (float)x;
                rectX = (float)x;
            }
        }
        if (drawRect) {
            fontRenderer.getClass();
            d = (double)(height - 9) / 2.0;
        } else {
            d = 0.0;
        }
        double vpad = d;
        switch (vAlign) {
            case Above: {
                rectY = y - (double)height;
                textY = (float)(rectY + vpad + (double)(!fontRenderer.func_78260_a() ? 1 : 0));
                break;
            }
            case Middle: {
                rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                textY = (float)(rectY + vpad);
                break;
            }
            case Below: {
                rectY = y;
                textY = (float)(rectY + vpad);
            }
        }
        if (rotation != 0) {
            stack.func_227861_a_(x, y, 0.0);
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(-rotation)));
            stack.func_227861_a_(-x, -y, 0.0);
        }
        Matrix4f matrixPos = stack.func_227866_c_().func_227870_a_();
        Matrix3f normal = stack.func_227866_c_().func_227872_b_();
        if (drawRect) {
            int backgroundColor = Minecraft.func_71410_x().field_71474_y.func_216841_b(bgAlpha);
            int hpad = 2;
            MatrixDrawUtil.drawRectangle(matrixPos, rectX - 2.0 - 0.5, rectY, bgWidth + 4.0, bgHeight, backgroundColor);
        }
        if (alpha < 1.0f) {
            color = RGB.toArbg(color, alpha);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        stack.func_227861_a_((double)textX - Math.floor(textX), (double)textY - Math.floor(textY), 0.0);
        fontRenderer.func_228079_a_(text, textX, textY, color, fontShadow, matrixPos, buffers, true, 0, 0xF000F0);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        stack.func_227865_b_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawQuad(MatrixStack stack, IVertexBuilder vertexBuilder, int color, float alpha, double x, double y, double width, double height, double minU, double minV, double maxU, double maxV, double rotation, boolean flip, boolean blend, int glBlendSfactor, int glBlendDFactor, boolean clampTexture) {
        try {
            stack.func_227860_a_();
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            if (rotation != 0.0) {
                double transX = x + width / 2.0;
                double transY = y + height / 2.0;
                stack.func_227861_a_(transX, transY, 0.0);
                stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(-rotation)));
                stack.func_227861_a_(-transX, -transY, 0.0);
            }
            float[] rgba = RGB.floats(color, alpha);
            float direction = (float)(flip ? -maxU : maxU);
            MatrixStack.Entry entry = stack.func_227866_c_();
            Matrix4f matrix4f = entry.func_227870_a_();
            Matrix3f matrix3f = entry.func_227872_b_();
            MatrixDrawUtil.addVertexUV(matrix4f, matrix3f, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (int)(height + y), (float)x, zLevel, (float)minU, (float)maxV);
            MatrixDrawUtil.addVertexUV(matrix4f, matrix3f, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (int)(height + y), (float)(x + width), zLevel, direction, (float)maxV);
            MatrixDrawUtil.addVertexUV(matrix4f, matrix3f, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (int)y, (float)(x + width), zLevel, direction, (float)minV);
            MatrixDrawUtil.addVertexUV(matrix4f, matrix3f, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (int)y, (float)x, zLevel, (float)minU, (float)minV);
        }
        finally {
            stack.func_227865_b_();
        }
    }

    public static void addBufferedVertexWithUV(BufferBuilder bufferIn, double x, double y, double z, double texU, double texV) {
        bufferIn.func_225582_a_(x, y, z).func_225583_a_((float)texU, (float)texV).func_181675_d();
    }

    public static void drawRectangle(Matrix4f matrixPos, double x, double y, double width, double height, int color) {
        MatrixDrawUtil.fill(matrixPos, (int)x, (int)y, (int)(x + width), (int)(height + y), color);
    }

    public static void fill(Matrix4f matrixPos, int x, int y, int bottomX, int bottomY, int color) {
        if (x < bottomX) {
            int i = x;
            x = bottomX;
            bottomX = i;
        }
        if (y < bottomY) {
            int j = y;
            y = bottomY;
            bottomY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_227888_a_(matrixPos, (float)x, (float)bottomY, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(matrixPos, (float)bottomX, (float)bottomY, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(matrixPos, (float)bottomX, (float)y, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_227888_a_(matrixPos, (float)x, (float)y, 0.0f).func_227885_a_(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableTexture();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
    }

    public static void addVertexUVOverlay(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder bufferIn, float red, float green, float blue, float alpha, int y, float x, float z, float texU, float texV, int overlayUV) {
        bufferIn.func_227888_a_(matrixPos, x, (float)y, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(texU, texV).func_227891_b_(overlayUV).func_227886_a_(0xF000F0).func_227887_a_(matrixNormal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public static void addVertexUV(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder bufferIn, float red, float green, float blue, float alpha, int y, float x, float z, float texU, float texV) {
        bufferIn.func_227888_a_(matrixPos, x, (float)y, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(texU, texV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrixNormal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public static void addVertex(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder bufferIn, float red, float green, float blue, float alpha, double x, double y, float z) {
        bufferIn.func_227888_a_(matrixPos, (float)x, (float)y, z).func_227885_a_(red, green, blue, alpha).func_227887_a_(matrixNormal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }
}

