/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.container.inventory;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryCraftBook
extends CraftingInventory
implements IRecipeHolder {
    private IRecipe<?> recipeUsed;

    public InventoryCraftBook(Container container) {
        super(container, 3, 3);
    }

    public ItemStack tryCraft(ItemStack outputItem, NonNullList<ItemStack> craftMatrix, PlayerEntity player, KitchenMultiBlock multiBlock) {
        int i;
        boolean requireContainer = CookingRegistry.doesItemRequireBucketForCrafting(outputItem);
        List<IKitchenItemProvider> inventories = CookingRegistry.getItemProviders(multiBlock, player.field_71071_by);
        for (IKitchenItemProvider itemProvider : inventories) {
            itemProvider.resetSimulation();
        }
        SourceItem[] sourceItems = new SourceItem[9];
        block1: for (i = 0; i < craftMatrix.size(); ++i) {
            ItemStack ingredient = (ItemStack)craftMatrix.get(i);
            if (ingredient.func_190926_b()) continue;
            for (int j = 0; j < inventories.size(); ++j) {
                IKitchenItemProvider itemProvider = inventories.get(j);
                SourceItem sourceItem = itemProvider.findSourceAndMarkAsUsed((it, count) -> it.func_185136_b(ingredient) && count > 0, 1, inventories, requireContainer, true);
                if (sourceItem == null) continue;
                sourceItems[i] = sourceItem;
                continue block1;
            }
        }
        for (i = 0; i < sourceItems.length; ++i) {
            this.func_70299_a(i, sourceItems[i] != null ? sourceItems[i].getSourceStack() : ItemStack.field_190927_a);
        }
        IRecipe craftRecipe = CookingRegistry.findFoodRecipe(this, player.field_70170_p);
        if (craftRecipe == null || craftRecipe.func_77571_b().func_190926_b() || craftRecipe.func_77571_b().func_77973_b() != outputItem.func_77973_b()) {
            return ItemStack.field_190927_a;
        }
        if (!craftRecipe.func_77569_a((IInventory)this, player.field_70170_p)) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = craftRecipe.func_77572_b((IInventory)this);
        if (!result.func_190926_b()) {
            this.fireEventsAndHandleAchievements(player, result);
            for (int i2 = 0; i2 < this.func_70302_i_(); ++i2) {
                ItemStack restStack;
                IKitchenItemProvider sourceProvider;
                ItemStack itemStack = this.func_70301_a(i2);
                if (itemStack.func_190926_b() || sourceItems[i2] == null || (sourceProvider = sourceItems[i2].getSourceProvider()) == null) continue;
                ItemStack containerItem = ForgeHooks.getContainerItem((ItemStack)itemStack);
                if (sourceItems[i2].getSourceSlot() != -1) {
                    sourceProvider.resetSimulation();
                    sourceProvider.consumeSourceItem(sourceItems[i2], 1, inventories, requireContainer);
                }
                if (containerItem.func_190926_b() || (restStack = sourceProvider.returnItemStack(containerItem, sourceItems[i2])).func_190926_b()) continue;
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)restStack);
            }
        }
        return result;
    }

    private void fireEventsAndHandleAchievements(PlayerEntity player, ItemStack result) {
        result.func_77980_a(player.field_70170_p, player, 1);
        BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)player, (ItemStack)result, (IInventory)this);
        this.func_201560_d(player);
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        this.recipeUsed = recipe;
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return this.recipeUsed;
    }
}

