/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

public class CachedDynamicModel
implements IBakedModel {
    private final Map<String, IBakedModel> cache = Maps.newHashMap();
    private final ModelBakery modelBakery;
    private final Function<BlockState, ResourceLocation> baseModelFunction;
    private final List<Pair<Predicate<BlockState>, IBakedModel>> parts;
    private final Function<BlockState, Map<String, String>> textureMapFunction;
    private final ResourceLocation location;
    private TextureAtlasSprite particleTexture;

    public CachedDynamicModel(ModelBakery modelBakery, Function<BlockState, ResourceLocation> baseModelFunction, @Nullable List<Pair<Predicate<BlockState>, IBakedModel>> parts, @Nullable Function<BlockState, Map<String, String>> textureMapFunction, ResourceLocation location) {
        this.modelBakery = modelBakery;
        this.baseModelFunction = baseModelFunction;
        this.parts = parts;
        this.textureMapFunction = textureMapFunction;
        this.location = location;
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (state != null) {
            Matrix4f transform = ModelRotation.X0_Y0.func_225615_b_().func_227988_c_();
            String stateString = state.toString();
            IBakedModel bakedModel = this.cache.get(stateString);
            if (bakedModel == null) {
                if (state.func_196959_b((IProperty)BlockKitchen.LOWERED) && ((Boolean)state.func_177229_b((IProperty)BlockKitchen.LOWERED)).booleanValue()) {
                    transform.func_226597_a_(new Vector3f(0.0f, -0.05f, 0.0f));
                }
                if (state.func_196959_b((IProperty)BlockKitchen.FACING)) {
                    float angle = ((Direction)state.func_177229_b((IProperty)BlockKitchen.FACING)).func_185119_l();
                    transform.func_226596_a_(new Quaternion(0.0f, 180.0f - angle, 0.0f, true));
                }
                ResourceLocation baseModelLocation = this.baseModelFunction.apply(state);
                IUnbakedModel retexturedBaseModel = this.textureMapFunction != null ? ModModels.retexture(this.modelBakery, baseModelLocation, this.textureMapFunction.apply(state)) : ModelLoader.instance().getModelOrMissing(baseModelLocation);
                SimpleModelTransform modelTransform = new SimpleModelTransform(new TransformationMatrix(transform));
                bakedModel = retexturedBaseModel.func_225613_a_(this.modelBakery, ModelLoader.defaultTextureGetter(), (IModelTransform)modelTransform, this.location);
                this.cache.put(stateString, bakedModel);
                if (this.particleTexture == null && bakedModel != null) {
                    this.particleTexture = bakedModel.getParticleTexture((IModelData)EmptyModelData.INSTANCE);
                }
            }
            return bakedModel != null ? bakedModel.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particleTexture != null ? this.particleTexture : ModelLoader.White.instance();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

