/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.block.BlockDyeableKitchen;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.SinkTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SinkBlock
extends BlockDyeableKitchen {
    public static final String name = "sink";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "sink");

    public SinkBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200948_a(5.0f, 10.0f), registryName);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, COLOR, HAS_COLOR, FLIPPED});
    }

    @Override
    @Nonnull
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        return (BlockState)state.func_206870_a((IProperty)FLIPPED, (Comparable)Boolean.valueOf(this.shouldBePlacedFlipped(context, (Direction)state.func_177229_b((IProperty)FACING))));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.tryRecolorBlock(state, heldItem, world, pos, player, rayTraceResult)) {
            return ActionResultType.SUCCESS;
        }
        ItemStack resultStack = CookingRegistry.getSinkOutput(heldItem);
        if (!resultStack.func_190926_b()) {
            CompoundNBT tagCompound = heldItem.func_77978_p();
            ItemStack newItem = resultStack.func_77946_l();
            if (tagCompound != null) {
                newItem.func_77982_d(tagCompound);
            }
            if (heldItem.func_190916_E() <= 1) {
                player.func_184611_a(hand, newItem);
            } else if (player.field_71071_by.func_70441_a(newItem)) {
                heldItem.func_190918_g(1);
            }
            this.spawnParticles(world, pos, state);
            world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() + 0.5f);
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            LazyOptional fluidHandlerCap = tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            if (!fluidHandlerCap.isPresent()) {
                this.spawnParticles(world, pos, state);
            } else {
                IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerCap.orElseThrow(IllegalStateException::new);
                if (!FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)fluidHandler)) {
                    if (heldItem.func_77973_b() == Items.field_151069_bo) {
                        FluidStack simulated = fluidHandler.drain(333, IFluidHandler.FluidAction.SIMULATE);
                        if (simulated.getAmount() == 333) {
                            fluidHandler.drain(333, IFluidHandler.FluidAction.EXECUTE);
                            if (player.func_191521_c(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b))) {
                                heldItem.func_190918_g(1);
                            }
                        } else {
                            this.spawnParticles(world, pos, state);
                        }
                    } else {
                        this.spawnParticles(world, pos, state);
                    }
                }
            }
            return !heldItem.func_190926_b() && !(heldItem.func_77973_b() instanceof BlockItem) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        return ActionResultType.SUCCESS;
    }

    private void spawnParticles(World world, BlockPos pos, BlockState state) {
        float dripWaterX = 0.0f;
        float dripWaterZ = 0.0f;
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                dripWaterZ = 0.25f;
                dripWaterX = -0.05f;
                break;
            }
            case SOUTH: {
                dripWaterX = 0.25f;
                break;
            }
            case WEST: {
                dripWaterX = 0.25f;
                dripWaterZ = 0.25f;
                break;
            }
            case EAST: {
                dripWaterZ = -0.05f;
            }
        }
        float particleX = (float)pos.func_177958_n() + 0.5f;
        float particleY = (float)pos.func_177956_o() + 1.25f;
        float particleZ = (float)pos.func_177952_p() + 0.5f;
        world.func_195594_a((IParticleData)ParticleTypes.field_218422_X, (double)particleX + (double)dripWaterX, (double)particleY - (double)0.45f, (double)particleZ + (double)dripWaterZ, 0.0, 0.0, 0.0);
        for (int i = 0; i < 5; ++i) {
            world.func_195594_a((IParticleData)ParticleTypes.field_218422_X, (double)particleX + Math.random() - 0.5, (double)particleY + Math.random() - 0.5, (double)particleZ + Math.random() - 0.5, 0.0, 0.0, 0.0);
        }
        world.func_184133_a(null, pos, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, 0.1f, world.field_73012_v.nextFloat() + 0.5f);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SinkTileEntity();
    }
}

