/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tile;

import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.MachineTile;
import com.hrznstudio.titanium.client.screen.addon.EnergyBarScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class IndustrialProcessingTile<T extends IndustrialProcessingTile<T>>
extends MachineTile<T> {
    @Save
    private ProgressBarComponent<T> progressBar;

    public IndustrialProcessingTile(BasicTileBlock<T> basicTileBlock, int x, int y) {
        super(basicTileBlock);
        this.addGuiAddonFactory(() -> new EnergyBarScreenAddon(10, 20, (IEnergyStorage)this.getEnergyStorage()));
        this.progressBar = new ProgressBarComponent(x, y, 100).setComponentHarness((IComponentHarness)this.getSelf()).setBarDirection(ProgressBarComponent.BarDirection.HORIZONTAL_RIGHT).setCanReset(tileEntity -> true).setOnStart(() -> this.progressBar.setMaxProgress(this.getMaxProgress())).setCanIncrease(tileEntity -> this.getEnergyStorage().getEnergyStored() > this.getTickPower() && this.canIncrease()).setOnTickWork(() -> this.getEnergyStorage().extractEnergyForced(this.getTickPower())).setOnFinishWork(() -> this.onFinish().run());
        this.addProgressBar(this.progressBar);
    }

    public ProgressBarComponent<T> getProgressBar() {
        return this.progressBar;
    }

    public ActionResultType onActivated(PlayerEntity playerIn, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        this.openGui(playerIn);
        return ActionResultType.PASS;
    }

    public int getMaxProgress() {
        return 100;
    }

    public abstract boolean canIncrease();

    public abstract Runnable onFinish();

    protected abstract int getTickPower();
}

