/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.core.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.core.FluidExtractorConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.FluidExtractorRecipe;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.energy.NBTEnergyHandler;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidExtractorTile
extends IndustrialAreaWorkingTile<FluidExtractorTile> {
    public static HashMap<DimensionType, HashMap<ChunkPos, HashMap<BlockPos, FluidExtractionProgress>>> EXTRACTION = new HashMap();
    private int maxProgress;
    private int powerPerOperation;
    private FluidExtractorRecipe currentRecipe;
    @Save
    private SidedFluidTankComponent<FluidExtractorTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("latex", FluidExtractorConfig.maxLatexTankSize, 43, 20, 0).setColor(DyeColor.LIGHT_GRAY).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.LATEX.getSourceFluid()));

    public FluidExtractorTile() {
        super(ModuleCore.FLUID_EXTRACTOR, RangeManager.RangeType.BEHIND);
        this.addTank((FluidTankComponent)this.tank);
        this.maxProgress = FluidExtractorConfig.maxProgress;
        this.powerPerOperation = FluidExtractorConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        BlockPos pos = this.getPointedBlockPos();
        if (this.isLoaded(pos)) {
            if (this.currentRecipe == null || !this.currentRecipe.matches(this.field_145850_b, pos)) {
                this.currentRecipe = this.findRecipe(this.field_145850_b, pos);
            }
            if (this.currentRecipe != null) {
                FluidExtractionProgress extractionProgress = EXTRACTION.computeIfAbsent(this.field_145850_b.field_73011_w.func_186058_p(), dimensionType -> new HashMap()).computeIfAbsent(this.field_145850_b.func_175726_f(pos).func_76632_l(), chunkPos -> new HashMap()).computeIfAbsent(pos, pos1 -> new FluidExtractionProgress(this.field_145850_b));
                this.tank.fillForced(this.currentRecipe.output.copy(), IFluidHandler.FluidAction.EXECUTE);
                if (this.field_145850_b.field_73012_v.nextDouble() <= (double)this.currentRecipe.breakChance) {
                    extractionProgress.setProgress(extractionProgress.getProgress() + 1);
                }
                if (extractionProgress.getProgress() > 7) {
                    extractionProgress.setProgress(0);
                    this.field_145850_b.func_175656_a(pos, this.currentRecipe.result.func_176223_P());
                }
                if (this.hasEnergy(this.powerPerOperation)) {
                    return new IndustrialWorkingTile.WorkAction(0.4f, this.powerPerOperation);
                }
                return new IndustrialWorkingTile.WorkAction(1.0f, 0);
            }
        }
        return new IndustrialWorkingTile.WorkAction(1.0f, 0);
    }

    protected IFactory<NBTEnergyHandler> getEnergyHandlerFactory() {
        return () -> new NBTEnergyHandler((BasicTile)this, FluidExtractorConfig.maxStoredPower);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nullable
    public FluidExtractorRecipe findRecipe(World world, BlockPos pos) {
        return RecipeUtil.getRecipes((World)world, (IRecipeType)FluidExtractorRecipe.SERIALIZER.getRecipeType()).stream().filter(fluidExtractorRecipe -> fluidExtractorRecipe.matches(world, pos) && !fluidExtractorRecipe.defaultRecipe).findFirst().orElseGet(() -> RecipeUtil.getRecipes((World)world, (IRecipeType)FluidExtractorRecipe.SERIALIZER.getRecipeType()).stream().filter(fluidExtractorRecipe -> fluidExtractorRecipe.matches(world, pos)).findFirst().orElse(null));
    }

    @Nonnull
    public FluidExtractorTile getSelf() {
        return this;
    }

    public static class FluidExtractionProgress {
        private int progress = 0;
        private int breakID;

        public FluidExtractionProgress(World world) {
            this.breakID = world.field_73012_v.nextInt();
        }

        public int getProgress() {
            return this.progress;
        }

        public void setProgress(int progress) {
            this.progress = progress;
        }

        public int getBreakID() {
            return this.breakID;
        }
    }
}

