/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.SlaughterFactoryConfig;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.energy.NBTEnergyHandler;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SlaughterFactoryTile
extends IndustrialAreaWorkingTile<SlaughterFactoryTile> {
    private int maxProgress;
    private int powerPerOperation;
    @Save
    private SidedFluidTankComponent<SlaughterFactoryTile> meat = (SidedFluidTankComponent)new SidedFluidTankComponent("meat", SlaughterFactoryConfig.maxMeatTankSize, 43, 20, 0).setColor(DyeColor.BROWN).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.MEAT.getSourceFluid()));
    @Save
    private SidedFluidTankComponent<SlaughterFactoryTile> pinkSlime;

    public SlaughterFactoryTile() {
        super(ModuleAgricultureHusbandry.SLAUGHTER_FACTORY, RangeManager.RangeType.BEHIND);
        this.addTank((FluidTankComponent)this.meat);
        this.pinkSlime = (SidedFluidTankComponent)new SidedFluidTankComponent("pink_slime", SlaughterFactoryConfig.maxPinkSlimeTankSize, 63, 20, 1).setColor(DyeColor.PINK).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.PINK_SLIME.getSourceFluid()));
        this.addTank((FluidTankComponent)this.pinkSlime);
        this.maxProgress = SlaughterFactoryConfig.maxProgress;
        this.powerPerOperation = SlaughterFactoryConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        List mobs;
        if (this.hasEnergy(this.powerPerOperation) && (mobs = this.field_145850_b.func_217357_a(MobEntity.class, this.getWorkingArea().func_197752_a())).size() > 0) {
            MobEntity entity = (MobEntity)mobs.get(0);
            float currentHealth = entity.func_110143_aJ();
            entity.remove(true);
            if (!entity.func_70089_S()) {
                this.meat.fillForced(new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid(), entity instanceof AnimalEntity ? (int)currentHealth : (int)currentHealth * 20), IFluidHandler.FluidAction.EXECUTE);
                this.pinkSlime.fillForced(new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid(), entity instanceof AnimalEntity ? (int)(currentHealth * 20.0f) : (int)currentHealth), IFluidHandler.FluidAction.EXECUTE);
                return new IndustrialWorkingTile.WorkAction(0.2f, this.powerPerOperation);
            }
        }
        return new IndustrialWorkingTile.WorkAction(1.0f, 0);
    }

    protected IFactory<NBTEnergyHandler> getEnergyHandlerFactory() {
        return () -> new NBTEnergyHandler((BasicTile)this, SlaughterFactoryConfig.maxStoredPower);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public SlaughterFactoryTile getSelf() {
        return this;
    }
}

