/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.condition.provider.base;

import com.valkyrieofnight.vlib.registry.condition.data.ConditionDataContainer;
import com.valkyrieofnight.vlib.registry.condition.data.base.ConditionID;
import com.valkyrieofnight.vlib.registry.condition.provider.IConditionalProvider;

public abstract class ValueProvider<RESULT>
implements IConditionalProvider<RESULT> {
    protected ConditionID valueID;

    public ValueProvider(ConditionID valueID) {
        this.valueID = valueID;
    }

    public static class ConditionalString
    extends ValueProvider<String> {
        public ConditionalString(ConditionID valueID) {
            super(valueID);
        }

        @Override
        public String request(ConditionDataContainer container) {
            return (String)container.getStringCondition(this.valueID).getValue();
        }
    }

    public static class ConditionalDouble
    extends ValueProvider<Double> {
        public ConditionalDouble(ConditionID valueID) {
            super(valueID);
        }

        @Override
        public Double request(ConditionDataContainer container) {
            return (Double)container.getDoubleCondition(this.valueID).getValue();
        }
    }

    public static class ConditionalFloat
    extends ValueProvider<Float> {
        public ConditionalFloat(ConditionID valueID) {
            super(valueID);
        }

        @Override
        public Float request(ConditionDataContainer container) {
            return (Float)container.getFloatCondition(this.valueID).getValue();
        }
    }

    public static class ConditionalLong
    extends ValueProvider<Long> {
        public ConditionalLong(ConditionID valueID) {
            super(valueID);
        }

        @Override
        public Long request(ConditionDataContainer container) {
            return (Long)container.getLongCondition(this.valueID).getValue();
        }
    }

    public static class ConditionalInt
    extends ValueProvider<Integer> {
        public ConditionalInt(ConditionID id) {
            super(id);
        }

        @Override
        public Integer request(ConditionDataContainer container) {
            return (Integer)container.getIntCondition(this.valueID).getValue();
        }
    }

    public static class ConditionalShort
    extends ValueProvider<Short> {
        public ConditionalShort(ConditionID valueID) {
            super(valueID);
        }

        @Override
        public Short request(ConditionDataContainer container) {
            return (Short)container.getShortCondition(this.valueID).getValue();
        }
    }

    public static class ConditionalByte
    extends ValueProvider<Byte> {
        public ConditionalByte(ConditionID valueID) {
            super(valueID);
        }

        @Override
        public Byte request(ConditionDataContainer container) {
            return (Byte)container.getByteCondition(this.valueID).getValue();
        }
    }

    public static class ConditionalBoolean
    extends ValueProvider<Boolean> {
        public ConditionalBoolean(ConditionID valueID) {
            super(valueID);
        }

        @Override
        public Boolean request(ConditionDataContainer container) {
            return (Boolean)container.getBooleanCondition(this.valueID).getValue();
        }
    }
}

