/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.condition.provider.base;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.registry.condition.data.ConditionDataContainer;
import com.valkyrieofnight.vlib.registry.condition.provider.IConditionalProvider;
import java.util.List;

public class SwitchProvider<RETURN_VALUE, TEST_TYPE>
implements IConditionalProvider<RETURN_VALUE> {
    private IConditionalProvider<TEST_TYPE> testCondition;
    private IConditionalProvider<RETURN_VALUE> returnDefault;
    private List<SwitchCase<RETURN_VALUE, TEST_TYPE>> cases = Lists.newArrayList();

    public SwitchProvider(IConditionalProvider<TEST_TYPE> testCondition, IConditionalProvider<RETURN_VALUE> returnDefault, List<SwitchCase<RETURN_VALUE, TEST_TYPE>> cases) {
        this.testCondition = testCondition;
        this.returnDefault = returnDefault;
        this.cases = cases;
    }

    @Override
    public RETURN_VALUE request(ConditionDataContainer container) {
        TEST_TYPE test = this.testCondition.request(container);
        for (SwitchCase<RETURN_VALUE, TEST_TYPE> c : this.cases) {
            if (!c.test(container, test)) continue;
            return c.request(container);
        }
        return this.returnDefault.request(container);
    }

    public static class SwitchCase<RETURN_VALUE, TEST_TYPE> {
        protected IConditionalProvider<TEST_TYPE> testValue;
        protected IConditionalProvider<RETURN_VALUE> result;

        public SwitchCase(IConditionalProvider<TEST_TYPE> testValue, IConditionalProvider<RETURN_VALUE> result) {
            this.testValue = testValue;
            this.result = result;
        }

        public boolean test(ConditionDataContainer container, TEST_TYPE val) {
            return this.testValue.request(container).equals(val);
        }

        public RETURN_VALUE request(ConditionDataContainer container) {
            return this.result.request(container);
        }
    }
}

