/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.condition.data;

import com.mojang.authlib.GameProfile;
import com.valkyrieofnight.vlib.registry.condition.data.ConditionDataContainer;
import com.valkyrieofnight.vlib.registry.condition.data.base.ConditionScope;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.world.dimension.DimensionType;

public class ConditionDataContainerHandler {
    private static ConditionDataContainerHandler INST;
    protected ConditionDataContainer allTemplate;
    protected ConditionDataContainer globalDatabaseTemplate;
    protected ConditionDataContainer dimensionDatabaseTemplate;
    protected ConditionDataContainer playerDatabaseTemplate;
    protected ConditionDataContainer globalDatabase;
    protected ConcurrentMap<DimensionType, ConditionDataContainer> dimensionDatabases;
    protected ConcurrentMap<GameProfile, ConditionDataContainer> playerDatabases;

    public static ConditionDataContainerHandler getInstance() {
        if (INST == null) {
            INST = new ConditionDataContainerHandler();
        }
        return INST;
    }

    private ConditionDataContainerHandler() {
    }

    public void reloadData(ConditionDataContainer allTemplate) {
        this.allTemplate = allTemplate;
        this.globalDatabaseTemplate = allTemplate.copyScoped(ConditionScope.GLOBAL);
        this.dimensionDatabaseTemplate = allTemplate.copyScoped(ConditionScope.WORLD);
        this.playerDatabaseTemplate = allTemplate.copyScoped(ConditionScope.PLAYER);
    }

    public ConditionDataContainer getGlobalDatabase() {
        return this.globalDatabase;
    }

    public ConditionDataContainer getDimensionDatabase(DimensionType dimensionType) {
        if (!this.dimensionDatabases.containsKey(dimensionType)) {
            return null;
        }
        return (ConditionDataContainer)this.dimensionDatabases.get(dimensionType);
    }

    public ConditionDataContainer getPlayerDatabase(GameProfile player) {
        if (!this.playerDatabases.containsKey(player)) {
            return null;
        }
        return (ConditionDataContainer)this.playerDatabases.get(player);
    }
}

