/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry._new;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.valkyrieofnight.vlib.core.io.json.ITypedDeserializer;
import java.util.Map;

public abstract class RecipeRegistry {
    private Map<String, ITypedDeserializer> typedDeserializerMap;
    private Gson gson;

    public RecipeRegistry() {
        this.addDeserializers();
        this.buildGson();
    }

    public void buildGson() {
        GsonBuilder gb = new GsonBuilder();
        for (ITypedDeserializer deser : this.typedDeserializerMap.values()) {
            gb.registerTypeAdapter(deser.getType(), (Object)deser);
        }
        this.gson = gb.create();
    }

    protected abstract void addDeserializers();

    protected void addDeserializer(ITypedDeserializer deserializer) {
        if (this.typedDeserializerMap.containsKey(deserializer.getTypeIdentifier())) {
            return;
        }
        this.typedDeserializerMap.put(deserializer.getTypeIdentifier(), deserializer);
    }

    public ITypedDeserializer getTypedDeserializer(String identifier) {
        return this.typedDeserializerMap.get(identifier);
    }
}

