/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.constructor;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import com.valkyrieofnight.vlib.core.util.convenience.ITick;
import com.valkyrieofnight.vlib.core.util.lambda.Action;
import com.valkyrieofnight.vlib.core.util.lambda.Action2a;
import com.valkyrieofnight.vlib.core.util.math.BlockOffset;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.core.util.nbt.NBTBuilder;
import com.valkyrieofnight.vlib.multiblock.Structure;
import com.valkyrieofnight.vlib.multiblock.component.Component;
import com.valkyrieofnight.vlib.multiblock.component.ComponentLayoutList;
import com.valkyrieofnight.vlib.multiblock.constructor.base.Formation;
import com.valkyrieofnight.vlib.multiblock.tile.ISlave;
import com.valkyrieofnight.vlib.multiblock.tile.impl.ControllerTile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@Deprecated
public class OldConstructor
implements ITick,
INBTSerializer {
    private int scanRateFORMED = 4;
    private int scanRateCONSTRUCT = 12;
    private ControllerTile tile;
    private Structure structure;
    private Queue<Map.Entry<BlockOffset, Component>> queue = Queues.newArrayDeque();
    private State state = State.INIT;
    private XYZOrientation orientation = XYZOrientation.PXPYPZ;
    private Formation formation;
    private boolean formed = false;
    private Action onConstructionComplete;
    private Action onReconstructionComplete;
    private Action onDeconstructionComplete;

    public OldConstructor(ControllerTile te) {
        this.tile = te;
        this.structure = this.tile.getStructure();
        this.formation = new Formation();
        this.formation.setup(this.structure);
    }

    public void setScanRates(int formed, int construct) {
        this.scanRateFORMED = formed;
        this.scanRateCONSTRUCT = construct;
    }

    public void setOnConstructionComplete(Action action) {
        this.onConstructionComplete = action;
    }

    public void setOnReconstructionComplete(Action action) {
        this.onReconstructionComplete = action;
    }

    public void setOnDeconstructionComplete(Action action) {
        this.onDeconstructionComplete = action;
    }

    private World getWorld() {
        return this.tile.func_145831_w();
    }

    private BlockPos getControllerPos() {
        return this.tile.func_174877_v();
    }

    private void changeState(State nState) {
        if (nState == this.state) {
            return;
        }
        if (this.state == State.DECONSTRUCT && !this.queue.isEmpty()) {
            return;
        }
        if (this.state == State.CONSTRUCT && !this.queue.isEmpty()) {
            return;
        }
        if (this.state == State.FORMED && nState != State.FORMED) {
            this.formed = false;
        }
        switch (nState) {
            case INIT: {
                if (!this.formation.isPartiallyUnformed() && !this.formation.isUnformed()) break;
                this.state = State.INIT;
                break;
            }
            case CONSTRUCT: {
                System.out.println("Scanning Direction: " + (Object)((Object)this.orientation));
                this.queue.clear();
                this.formation.populateQueueWithAll(this.structure, this.queue);
                this.state = State.CONSTRUCT;
                break;
            }
            case DECONSTRUCT: {
                this.queue.clear();
                this.formation.populateQueueWithClaimed(this.structure, this.queue);
                this.state = State.DECONSTRUCT;
                break;
            }
            case FORMED: {
                if (!this.formed) break;
                this.queue.clear();
                this.state = State.FORMED;
            }
        }
    }

    private void scan(int count, Action2a<Map.Entry<BlockOffset, Component>, TileEntity> action3a) {
        for (int i = 0; i < count && !this.queue.isEmpty(); ++i) {
            Map.Entry<BlockOffset, Component> ent = this.queue.poll();
            if (ent == null) continue;
            Component comp = ent.getValue();
            BlockPos p = ent.getKey().getRotatedPosition(this.orientation, this.tile.func_174877_v());
            TileEntity te = this.tile.func_145831_w().func_175625_s(p);
            action3a.execute(ent, te);
        }
    }

    @Override
    public void tick() {
        switch (this.state) {
            case INIT: {
                break;
            }
            case CONSTRUCT: {
                this.scan(this.scanRateCONSTRUCT, (ent, te) -> {
                    if (te instanceof ISlave && ((Component)ent.getValue()).isValid((TileEntity)te) && !((ISlave)te).hasController()) {
                        this.formation.setClaimed((BlockOffset)ent.getKey(), true);
                        ((ISlave)te).setController(this.tile);
                    } else {
                        this.changeState(State.DECONSTRUCT);
                    }
                });
                if (this.queue.isEmpty() && this.formation.isFormed()) {
                    this.formed = true;
                    System.out.println("Formed: " + (Object)((Object)this.orientation));
                    this.changeState(State.FORMED);
                    if (this.onConstructionComplete == null) break;
                    this.onConstructionComplete.execute();
                    break;
                }
                this.changeState(State.DECONSTRUCT);
                break;
            }
            case FORMED: {
                this.scan(this.scanRateFORMED, (ent, te) -> {
                    if (!(te instanceof ISlave) || !((Component)ent.getValue()).isValid((TileEntity)te)) {
                        this.formation.setClaimed((BlockOffset)ent.getKey(), false);
                        this.changeState(State.INIT);
                    }
                });
            }
        }
    }

    public void onBreak(BlockPos pos) {
        System.out.println("Broken: " + pos);
        BlockOffset oof = BlockOffset.getOffset(this.tile.func_174877_v(), pos);
        BlockOffset off = this.orientation.getRotated(oof);
        if (!this.structure.contains(off)) {
            return;
        }
        Component comp = this.structure.getComponent(off);
        Map.Entry entry = Maps.immutableEntry((Object)off, (Object)comp);
    }

    public boolean isFormed() {
        return this.formation.isFormed();
    }

    public boolean isDeformed() {
        return this.formation.isUnformed();
    }

    public boolean changeStructure(Structure newStructure) {
        if (this.isDeformed()) {
            this.structure = this.structure;
            this.changeState(State.INIT);
            return true;
        }
        return false;
    }

    public XYZOrientation getOrientation() {
        return this.orientation;
    }

    public boolean isSlave(BlockPos pos) {
        BlockOffset o1 = this.orientation.getRotatedOpposite(BlockOffset.getOffset(pos, this.getControllerPos()));
        System.out.println(this.formation.check(o1) + " " + o1);
        return this.formation.check(o1);
    }

    public List<BlockPos> getAllOfType(Component component) {
        ComponentLayoutList list = this.structure.getLayoutList(component);
        if (list == null) {
            return new ArrayList<BlockPos>();
        }
        return list.getAllRotated(this.getControllerPos(), this.orientation);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = NBTBuilder.create().put("formation", (INBT)this.formation.serializeNBT()).putInt("direction", this.orientation.getIndex()).build();
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.formation.deserializeNBT(nbt.func_74775_l("formation"));
        this.orientation = XYZOrientation.getByIndex(nbt.func_74762_e("orientation"));
    }

    protected static enum State {
        INIT,
        CONSTRUCT,
        DECONSTRUCT,
        FORMED;

    }
}

