/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.constructor;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import com.valkyrieofnight.vlib.core.util.convenience.ITick;
import com.valkyrieofnight.vlib.core.util.lambda.Action;
import com.valkyrieofnight.vlib.core.util.lambda.Action2a;
import com.valkyrieofnight.vlib.core.util.math.BlockOffset;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.core.util.nbt.NBTBuilder;
import com.valkyrieofnight.vlib.multiblock.Structure;
import com.valkyrieofnight.vlib.multiblock.component.Component;
import com.valkyrieofnight.vlib.multiblock.component.ComponentLayoutList;
import com.valkyrieofnight.vlib.multiblock.constructor.base.Formation;
import com.valkyrieofnight.vlib.multiblock.tile.ISlave;
import com.valkyrieofnight.vlib.multiblock.tile.impl.ControllerTile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class ContinuousConstructor
implements ITick,
INBTSerializer {
    private int scanRateFormed = 4;
    private int scanRateConstruct = 12;
    private ControllerTile tile;
    private int structureID;
    private Queue<Map.Entry<BlockOffset, Component>> queue = Queues.newArrayDeque();
    private State state = State.SETUP;
    private XYZOrientation orientation;
    private Formation formation;
    private Action onConstructionComplete;
    private Action onReconstructionComplete;
    private Action onDeconstructionComplete;

    public ContinuousConstructor(ControllerTile te) {
        this.tile = te;
        this.formation = new Formation();
        this.structureID = this.tile.getStructureID();
        this.formation.setup(this.tile.getStructureList().getStructure(this.structureID));
    }

    @Override
    public CompoundNBT serializeNBT() {
        return NBTBuilder.create().put("formation", (INBT)this.formation.serializeNBT()).putInt("direction", this.orientation.getIndex()).putInt("structure", this.structureID).build();
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.formation.deserializeNBT(nbt.func_74775_l("formation"));
        this.orientation = XYZOrientation.getByIndex(nbt.func_74762_e("direction"));
        this.structureID = nbt.func_74762_e("structure");
    }

    private Structure getStructure() {
        return this.tile.getStructureList().getStructure(this.structureID);
    }

    @Override
    public void tick() {
        Structure s = this.getStructure();
        switch (this.state) {
            case SETUP: {
                if (this.structureID != this.tile.getStructureID()) {
                    this.structureID = this.tile.getStructureID();
                    this.orientation = XYZOrientation.PXPYPZ;
                    this.formation.setFormed(false);
                    this.queue.clear();
                    s = this.getStructure();
                    this.formation.setup(s);
                    this.formation.populateQueueWithAll(s, this.queue);
                } else {
                    this.orientation = s.getNextOrientation(this.orientation);
                    this.formation.populateQueueWithAll(s, this.queue);
                }
                this.changeState(State.CONSTRUCT);
                break;
            }
            case CONSTRUCT: {
                this.scan(this.scanRateConstruct, (ent, te) -> {
                    if (te instanceof ISlave && ((Component)ent.getValue()).isValid((TileEntity)te) && !((ISlave)te).hasController()) {
                        this.formation.setClaimed((BlockOffset)ent.getKey(), true);
                        ((ISlave)te).setController(this.tile);
                    } else {
                        this.deform();
                    }
                });
                if (this.queue.isEmpty() && this.formation.isFormed()) {
                    this.changeState(State.FORMED);
                    System.out.println("Formed : " + (Object)((Object)this.orientation));
                    if (this.onConstructionComplete != null) {
                        this.onConstructionComplete.execute();
                    }
                }
                if (!this.queue.isEmpty() || !this.formation.isPartiallyUnformed() && !this.formation.isUnformed()) break;
                this.deform();
                break;
            }
            case FORMED: {
                this.scan(this.scanRateFormed, (ent, te) -> {
                    if (te instanceof ISlave && ((Component)ent.getValue()).isValid((TileEntity)te)) {
                        if (!this.isSlave(te.func_174877_v()) || !this.tile.func_174877_v().equals((Object)((ISlave)te).getController())) {
                            this.deform();
                        }
                    } else {
                        this.deform();
                    }
                });
                if (!this.queue.isEmpty() || !this.formation.isFormed()) break;
                this.formation.populateQueueWithAll(this.getStructure(), this.queue);
                break;
            }
            case DEFORM: {
                this.scan(this.scanRateConstruct, (ent, te) -> {
                    if (te instanceof ISlave) {
                        ((ISlave)te).removeController(this.tile.func_174877_v());
                        this.formation.setClaimed((BlockOffset)ent.getKey(), false);
                    }
                });
                if (!this.queue.isEmpty()) break;
                this.changeState(State.SETUP);
            }
        }
    }

    private void deform() {
        this.queue.clear();
        this.formation.populateQueueWithClaimed(this.getStructure(), this.queue);
        this.changeState(State.DEFORM);
    }

    private void changeState(State nState) {
        this.state = nState;
    }

    private void scan(int count, Action2a<Map.Entry<BlockOffset, Component>, TileEntity> action3a) {
        for (int i = 0; i < count && !this.queue.isEmpty(); ++i) {
            Map.Entry<BlockOffset, Component> ent = this.queue.poll();
            if (ent == null) continue;
            Component comp = ent.getValue();
            BlockPos p = ent.getKey().getRotatedPosition(this.orientation, this.tile.func_174877_v());
            TileEntity te = this.tile.func_145831_w().func_175625_s(p);
            action3a.execute(ent, te);
        }
    }

    public XYZOrientation getOrientation() {
        return this.orientation;
    }

    public void onBreak(BlockPos pos) {
        System.out.println("Broken: " + pos);
        BlockOffset oof = BlockOffset.getOffset(this.tile.func_174877_v(), pos);
        BlockOffset off = this.orientation.getRotated(oof);
        if (!this.getStructure().contains(off)) {
            return;
        }
        Component comp = this.getStructure().getComponent(off);
        Map.Entry entry = Maps.immutableEntry((Object)off, (Object)comp);
    }

    public boolean isFormed() {
        return this.formation.isFormed();
    }

    public boolean isDeformed() {
        return this.formation.isUnformed();
    }

    public boolean isSlave(BlockPos pos) {
        BlockOffset o1 = this.orientation.getRotatedOpposite(BlockOffset.getOffset(pos, this.tile.func_174877_v()));
        return this.formation.check(o1);
    }

    public List<BlockPos> getAllOfType(Component component) {
        ComponentLayoutList list = this.getStructure().getLayoutList(component);
        if (list == null) {
            return new ArrayList<BlockPos>();
        }
        return list.getAllRotated(this.tile.func_174877_v(), this.orientation);
    }

    public void setOnConstructionComplete(Action action) {
        this.onConstructionComplete = action;
    }

    public void setOnReconstructionComplete(Action action) {
        this.onReconstructionComplete = action;
    }

    public void setOnDeconstructionComplete(Action action) {
        this.onDeconstructionComplete = action;
    }

    private static enum State {
        SETUP,
        CONSTRUCT,
        FORMED,
        DEFORM;

    }
}

