/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.wrapped;

import com.valkyrieofnight.vlib.core.debug.SimpleDebugger;
import com.valkyrieofnight.vlib.core.obj.block.base.IProvideBlockProps;
import com.valkyrieofnight.vlib.core.obj.block.base.IProvideCustomItemBlock;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeID;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeRegistry;
import com.valkyrieofnight.vlib.core.util.modloader.IMCRegistry;
import com.valkyrieofnight.vlib.core.util.modloader.forge.IReloadListener;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import org.jetbrains.annotations.NotNull;

public abstract class VLRegistry
implements IMCRegistry {
    protected IMCRegistry REG;
    protected SimpleDebugger db;

    public VLRegistry(SimpleDebugger debugger, IMCRegistry reg) {
        this.REG = reg;
        this.db = debugger;
    }

    @Override
    public void registerBlock(@NotNull Block block) {
        if (block == null) {
            this.db.log("ERROR: Tried registering null block");
            return;
        }
        this.REG.registerBlock(block);
        if (block instanceof IProvideCustomItemBlock) {
            this.registerItem((Item)((IProvideCustomItemBlock)block).getCustomBlockItem(block));
        } else {
            BlockItem bi = block instanceof IProvideBlockProps ? new BlockItem(block, ((IProvideBlockProps)block).getBlockProps().getItemProperties()) : new BlockItem(block, new Item.Properties());
            bi.setRegistryName(block.getRegistryName());
            this.registerItem((Item)bi);
        }
    }

    @Override
    public void registerTileType(@NotNull TileEntityType<?> tile) {
        if (tile == null) {
            this.db.log("ERROR: Tried registering null TileType");
            return;
        }
        this.REG.registerTileType(tile);
    }

    @Override
    public void registerItem(@NotNull Item item) {
        if (item == null) {
            this.db.log("ERROR: Tried registering null Item");
            return;
        }
        this.REG.registerItem(item);
    }

    @Override
    public void registerFluid(@NotNull Fluid fluid) {
        if (fluid == null) {
            this.db.log("ERROR: Tried registering null Fluid");
            return;
        }
        this.REG.registerFluid(fluid);
    }

    @Override
    public void registerEntityType(@NotNull EntityType<?> entity) {
        if (entity == null) {
            this.db.log("ERROR: Tried registering null EntityType");
            return;
        }
        this.REG.registerEntityType(entity);
    }

    @Override
    public void registerPotion(@NotNull Potion potion) {
        if (potion == null) {
            this.db.log("ERROR: Tried registering null Potion");
            return;
        }
        this.REG.registerPotion(potion);
    }

    @Override
    public void registerDimensionType(@NotNull DimensionType dimension) {
        if (dimension == null) {
            this.db.log("ERROR: Tried registering null DimensionType");
            return;
        }
        this.REG.registerDimensionType(dimension);
    }

    @Override
    public void registerEffect(@NotNull Effect effect) {
        if (effect == null) {
            this.db.log("ERROR: Tried registering null Effect");
            return;
        }
        this.REG.registerEffect(effect);
    }

    @Override
    public void registerEnchantment(@NotNull Enchantment enchant) {
        if (enchant == null) {
            this.db.log("ERROR: Tried registering null Enchantment");
            return;
        }
        this.REG.registerEnchantment(enchant);
    }

    @Override
    public void registerContainerType(@NotNull ContainerType<?> container) {
        if (container == null) {
            this.db.log("ERROR: Tried registering null ContainerType");
            return;
        }
        this.REG.registerContainerType(container);
    }

    @Override
    public void registerRecipeType(@NotNull IRecipeType<?> recipeType) {
        if (recipeType == null) {
            this.db.log("ERROR: Tried registering null IRecipeType");
            return;
        }
        this.REG.registerRecipeType(recipeType);
    }

    @Override
    public void registerRecipeSerializer(@NotNull IRecipeSerializer<?> recipeSerializer) {
        if (recipeSerializer == null) {
            this.db.log("ERROR: Tried registering null IRecipeSerializer");
            return;
        }
        this.REG.registerRecipeSerializer(recipeSerializer);
    }

    @Override
    public void registerReloadListener(@NotNull IReloadListener listener) {
        this.REG.registerReloadListener(listener);
    }

    public void createTheme(ThemeID themeID) {
        if (themeID == null) {
            this.db.log("ERROR: Tried creating theme with id: " + themeID + " but failed in the process");
            return;
        }
        this.getThemeRegistry().createTheme(themeID);
    }

    public abstract ThemeRegistry getThemeRegistry();

    public static Tag<Block> registerTagBlock(@NotNull VLID id) {
        return BlockTags.func_199896_a().func_199915_b((ResourceLocation)id);
    }

    public static Tag<Fluid> registerTagFluid(@NotNull VLID id) {
        return FluidTags.func_226157_a_().func_199915_b((ResourceLocation)id);
    }

    public static Tag<Item> registerTagItem(@NotNull VLID id) {
        return ItemTags.func_199903_a().func_199915_b((ResourceLocation)id);
    }

    public static Tag<EntityType<?>> registerTagEntityType(@NotNull VLID id) {
        return EntityTypeTags.func_219762_a().func_199915_b((ResourceLocation)id);
    }
}

