/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.math;

import com.valkyrieofnight.vlib.core.util.math.BlockOffset;
import com.valkyrieofnight.vlib.core.util.math.XYZDirection;

public enum XYZOrientation {
    PXPYPZ(0, XYZDirection.POS_X, XYZDirection.POS_Y, XYZDirection.POS_Z, 0),
    PXPYNX(1, XYZDirection.POS_Z, XYZDirection.POS_Y, XYZDirection.NEG_X, 3),
    NXPYNZ(2, XYZDirection.NEG_X, XYZDirection.POS_Y, XYZDirection.NEG_Z, 2),
    NZPYPX(3, XYZDirection.NEG_Z, XYZDirection.POS_Y, XYZDirection.POS_X, 1),
    PXNYNZ(4, XYZDirection.POS_X, XYZDirection.NEG_Y, XYZDirection.NEG_Z, 4),
    PZNYPX(5, XYZDirection.POS_Z, XYZDirection.NEG_Y, XYZDirection.POS_X, 7),
    NXNYPZ(6, XYZDirection.NEG_X, XYZDirection.NEG_Y, XYZDirection.POS_Z, 6),
    NZNYNX(7, XYZDirection.NEG_Z, XYZDirection.NEG_Y, XYZDirection.NEG_X, 5),
    NYPXPZ(8, XYZDirection.NEG_Y, XYZDirection.POS_X, XYZDirection.POS_Z, 18),
    PZPXPY(9, XYZDirection.POS_Z, XYZDirection.POS_X, XYZDirection.POS_Y, 14),
    PYPXNZ(10, XYZDirection.POS_Y, XYZDirection.POS_X, XYZDirection.NEG_Z, 10),
    NZPXNY(11, XYZDirection.NEG_Z, XYZDirection.POS_X, XYZDirection.NEG_Y, 22),
    NYPZNX(12, XYZDirection.NEG_Y, XYZDirection.POS_Z, XYZDirection.NEG_X, 17),
    NXPZPY(13, XYZDirection.NEG_X, XYZDirection.POS_Z, XYZDirection.POS_Y, 13),
    PYPZPX(14, XYZDirection.POS_Y, XYZDirection.POS_Z, XYZDirection.POS_X, 9),
    PXPZNY(15, XYZDirection.POS_X, XYZDirection.POS_Z, XYZDirection.NEG_Y, 21),
    NYNXNZ(16, XYZDirection.NEG_Y, XYZDirection.NEG_X, XYZDirection.NEG_Z, 16),
    NZNXPY(17, XYZDirection.NEG_Z, XYZDirection.NEG_X, XYZDirection.POS_Y, 12),
    PYNXPZ(18, XYZDirection.POS_Y, XYZDirection.NEG_X, XYZDirection.POS_Z, 8),
    PZNXNY(19, XYZDirection.POS_Z, XYZDirection.NEG_X, XYZDirection.NEG_Y, 20),
    NYNZPX(20, XYZDirection.NEG_Y, XYZDirection.NEG_Z, XYZDirection.POS_X, 19),
    PXNZPY(21, XYZDirection.POS_X, XYZDirection.NEG_Z, XYZDirection.POS_Y, 15),
    PYNZNX(22, XYZDirection.POS_Y, XYZDirection.NEG_Z, XYZDirection.NEG_X, 11),
    NXNZNY(23, XYZDirection.NEG_X, XYZDirection.NEG_Z, XYZDirection.NEG_Y, 23);

    private final int index;
    private final XYZDirection f;
    private final XYZDirection u;
    private final XYZDirection r;
    private final int indexReverseRotation;
    private static final XYZOrientation[] ALL;

    private XYZOrientation(int index, XYZDirection forward, XYZDirection up, XYZDirection right, int indexReverseRotation) {
        this.index = index;
        this.f = forward;
        this.u = up;
        this.r = right;
        this.indexReverseRotation = indexReverseRotation;
    }

    public BlockOffset getRotated(BlockOffset in) {
        return new BlockOffset(in.getValue(this.f), in.getValue(this.u), in.getValue(this.r));
    }

    public BlockOffset getRotatedOpposite(BlockOffset in) {
        XYZOrientation opposite = XYZOrientation.getByIndex(this.indexReverseRotation);
        return opposite.getRotated(in);
    }

    public int getIndex() {
        return this.index;
    }

    public static XYZOrientation getByIndex(int index) {
        return ALL[index % ALL.length];
    }

    public static XYZOrientation[] getAll() {
        return ALL;
    }

    static {
        ALL = XYZOrientation.values();
    }
}

