/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.math;

import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import com.valkyrieofnight.vlib.core.util.math.XYZDirection;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.core.util.nbt.NBTBuilder;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class BlockOffset
implements INBTSerializer {
    private int x;
    private int y;
    private int z;

    public BlockOffset(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockOffset() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    public BlockOffset(BlockPos pos) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public BlockPos getPosition(BlockPos centerPos) {
        return new BlockPos(centerPos.func_177958_n() + this.x, centerPos.func_177956_o() + this.y, centerPos.func_177952_p() + this.z);
    }

    public int getValue(XYZDirection in) {
        switch (in) {
            case POS_X: {
                return this.x;
            }
            case POS_Y: {
                return this.y;
            }
            case POS_Z: {
                return this.z;
            }
            case NEG_X: {
                return -this.x;
            }
            case NEG_Y: {
                return -this.y;
            }
            case NEG_Z: {
                return -this.z;
            }
        }
        return 0;
    }

    public BlockPos getRotatedPosition(XYZOrientation orientation, BlockPos centerPos) {
        BlockOffset rotated = orientation.getRotated(this);
        return new BlockPos(centerPos.func_177958_n() + rotated.getXOffset(), centerPos.func_177956_o() + rotated.getYOffset(), centerPos.func_177952_p() + rotated.getZOffset());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockOffset) {
            return this.same((BlockOffset)obj);
        }
        return false;
    }

    public int hashCode() {
        return (this.y + this.z * 31) * 31 + this.x;
    }

    public boolean same(BlockOffset oth) {
        return this.x == oth.getXOffset() && this.y == oth.getYOffset() && this.z == oth.getZOffset();
    }

    public int getXOffset() {
        return this.x;
    }

    public int getYOffset() {
        return this.y;
    }

    public int getZOffset() {
        return this.z;
    }

    public String toString() {
        String str = "(";
        str = str + this.x + "," + this.y + "," + this.z + ")";
        return str;
    }

    public static BlockOffset getOffset(BlockPos pos, BlockPos offset) {
        return new BlockOffset(pos.func_177973_b((Vec3i)offset));
    }

    public static BlockOffset minEachValue(BlockOffset one, BlockOffset two) {
        return new BlockOffset(Math.min(one.getXOffset(), two.getXOffset()), Math.min(one.getYOffset(), two.getYOffset()), Math.min(one.getZOffset(), two.getZOffset()));
    }

    public static BlockOffset maxEachValue(BlockOffset one, BlockOffset two) {
        return new BlockOffset(Math.max(one.getXOffset(), two.getXOffset()), Math.max(one.getYOffset(), two.getYOffset()), Math.max(one.getZOffset(), two.getZOffset()));
    }

    @Override
    public CompoundNBT serializeNBT() {
        return NBTBuilder.create().putInt("x", this.x).putInt("y", this.y).putInt("z", this.z).build();
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.x = nbt.func_74762_e("x");
        this.y = nbt.func_74762_e("y");
        this.z = nbt.func_74762_e("z");
    }
}

