/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.game;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TickUtils {
    private static final long ONE_MILLISECOND = 1L;
    private static final long MILLISECONDS_IN_A_SECOND = 1000L;
    private static final long ONE_SECOND = 1000L;
    private static final long SECONDS_IN_A_MINUTE = 60L;
    private static final long ONE_MINUTE = 60000L;
    private static final long MINUTES_IN_AN_HOUR = 60L;
    private static final long ONE_HOUR = 3600000L;
    private static final long HOURS_IN_A_DAY = 24L;
    private static final long ONE_DAY = 86400000L;
    private static final long DAYS_IN_A_YEAR = 365L;

    public static long toSeconds(long ticks) {
        if (ticks == 0L) {
            return 0L;
        }
        return ticks / 20L;
    }

    public static int toSeconds(int ticks) {
        if (ticks == 0) {
            return 0;
        }
        return ticks / 20;
    }

    public static int fromSeconds(int seconds) {
        if (seconds == 0) {
            return 0;
        }
        return seconds * 20;
    }

    public static long fromSeconds(long seconds) {
        if (seconds == 0L) {
            return 0L;
        }
        return seconds * 20L;
    }

    public static long toMilliseconds(long ticks) {
        return ticks * 50L;
    }

    public static String toFormattedTime(long ticks, Date date, DateFormat dateFormat) {
        date.setTime(TickUtils.toMilliseconds(ticks));
        return dateFormat.format(date);
    }

    public static String toFormattedTime(long ticks, DateFormat dateFormat) {
        return TickUtils.toFormattedTime(ticks, new Date(), dateFormat);
    }

    public static String toFormattedTime(long ticks) {
        return TickUtils.toFormattedTime(ticks, new Date(), new SimpleDateFormat("HH/mm/ss.SSS"));
    }

    public static String toFormattedHMSM(long ticks) {
        return TickUtils.formatHMSM(TickUtils.toMilliseconds(ticks));
    }

    public static String toFormattedHMS(long ticks) {
        return TickUtils.formatHMS(TickUtils.toSeconds(ticks));
    }

    private static String formatHMSM(long duration) {
        String res = "";
        if (duration != 0L) {
            int milli = (int)((duration /= 1L) % 1000L);
            int seconds = (int)((duration /= 1000L) % 60L);
            int minutes = (int)((duration /= 60L) % 60L);
            int hours = (int)((duration /= 60L) % 24L);
            int days = (int)((duration /= 24L) % 365L);
            int years = (int)(duration /= 365L);
            res = days == 0 ? String.format("%02dh%02dm%02ds%03dms", hours, minutes, seconds, milli) : (years == 0 ? String.format("%ddays %02dh%02dm%02ds%03dms", days, hours, minutes, seconds, milli) : String.format("%dyrs %ddays %02dh%02dm%02ds", years, days, hours, minutes, seconds));
        }
        return res;
    }

    private static String formatHMS(long seconds) {
        String res = "";
        int secs = (int)(seconds % 60L);
        int minutes = (int)((seconds /= 60L) % 60L);
        int hours = (int)((seconds /= 60L) % 24L);
        int days = (int)((seconds /= 24L) % 365L);
        int years = (int)(seconds /= 365L);
        res = days == 0 ? String.format("%02dh%02dm%02ds", hours, minutes, secs) : (years == 0 ? String.format("%ddays %02dh%02dm%02ds", days, hours, minutes, secs) : String.format("%dyrs %ddays %02dh%02dm", years, days, hours, minutes, secs));
        return res;
    }
}

