/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.color;

import com.valkyrieofnight.vlib.core.util.color.ColorUtil;

public class Color4 {
    protected final float r;
    protected final float g;
    protected final float b;
    protected final float a;
    protected final int ri;
    protected final int gi;
    protected final int bi;
    protected final int ai;
    protected final int color;

    public Color4() {
        this(1, 1, 1, 1);
    }

    public Color4(int color) {
        this(ColorUtil.getR(color), ColorUtil.getG(color), ColorUtil.getB(color), ColorUtil.getA(color));
    }

    public static int calcMCColor(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public static int calcMCColor(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public Color4(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public Color4(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color4(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.ri = (int)(this.r * 255.0f);
        this.gi = (int)(this.g * 255.0f);
        this.bi = (int)(this.b * 255.0f);
        this.ai = (int)(this.a * 255.0f);
        this.color = ColorUtil.calcMCColor(this.ri, this.gi, this.bi, this.ai);
    }

    public Color4(int r, int g, int b, int a) {
        this.ri = r;
        this.gi = g;
        this.bi = b;
        this.ai = a;
        this.r = (float)this.ri / 255.0f;
        this.g = (float)this.gi / 255.0f;
        this.b = (float)this.bi / 255.0f;
        this.a = (float)this.ai / 255.0f;
        this.color = ColorUtil.calcMCColor(this.ri, this.gi, this.bi, this.ai);
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public float getA() {
        return this.b;
    }

    public int getRi() {
        return this.ri;
    }

    public int getGi() {
        return this.gi;
    }

    public int getBi() {
        return this.bi;
    }

    public int getAi() {
        return this.ai;
    }

    public int getMCColor() {
        return this.color;
    }

    public static Color4 from(int r, int g, int b) {
        return new Color4(ColorUtil.getRF(r), ColorUtil.getGF(g), ColorUtil.getBF(b));
    }

    public static Color4 from(int r, int g, int b, int a) {
        return new Color4(ColorUtil.getRF(r), ColorUtil.getGF(g), ColorUtil.getBF(b), ColorUtil.getAF(a));
    }
}

