/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.stack;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDrawTooltip;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementUpdate;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.util.client.TextComponentUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class ItemStackSequenceElement
extends VLElement
implements IElementDraw,
IElementDrawTooltip,
IElementUpdate {
    protected List<ItemStack> stacks;
    protected int ticks = 0;
    protected int ticksPerItem = 20;
    protected ItemStack currentItem = ItemStack.field_190927_a;
    protected int currentIndex;
    protected boolean drawToolTip = true;
    protected boolean renderStackSize = false;
    protected FontRenderer textRenderer;

    public ItemStackSequenceElement(String id, List<ItemStack> stacks) {
        super(id);
        this.textRenderer = Minecraft.func_71410_x().field_71466_p;
        this.stacks = stacks;
    }

    public ItemStackSequenceElement(String id, ItemStack stack) {
        super(id);
        this.textRenderer = Minecraft.func_71410_x().field_71466_p;
        this.stacks = Lists.newArrayList();
    }

    public ItemStackSequenceElement(String id) {
        super(id);
        this.textRenderer = Minecraft.func_71410_x().field_71466_p;
        this.stacks = Lists.newArrayList();
    }

    public void setDrawToolTip(boolean opt) {
        this.drawToolTip = opt;
    }

    public ItemStackSequenceElement setTicksPerItem(int t) {
        this.ticksPerItem = t;
        return this;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        GuiUtils.enableStandardItemLighting();
        Minecraft.func_71410_x().func_175599_af().func_180450_b(this.currentItem, this.getActualX(), this.getActualY());
        if (this.renderStackSize) {
            Minecraft.func_71410_x().func_175599_af().func_180453_a(this.textRenderer, this.currentItem, this.getActualX(), this.getActualY(), "" + this.currentItem.func_190916_E());
        }
        GuiUtils.disableStandardItemLighting();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
    }

    @Override
    public void drawTooltips(int mouseX, int mouseY) {
        if (!this.drawToolTip) {
            return;
        }
        if (this.withinBoxAndGui(mouseX, mouseY, this.getActualX(), this.getActualY(), this.getSizeX(), this.getSizeY())) {
            boolean advancedItemTooltips = Minecraft.func_71410_x().field_71474_y.field_82882_x;
            ITooltipFlag.TooltipFlags flag = advancedItemTooltips ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            List<String> tt = TextComponentUtil.convertToFormatted(this.currentItem.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)flag));
            this.getContainer().getGui().renderTooltip(tt, mouseX, mouseY);
        }
    }

    @Override
    public void load(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public int getSizeX() {
        return 16;
    }

    @Override
    public int getSizeY() {
        return 16;
    }

    @Override
    public void update() {
        ++this.ticks;
        if (this.ticks >= this.ticksPerItem) {
            ++this.currentIndex;
            if (this.currentIndex >= this.stacks.size()) {
                this.currentIndex = 0;
            }
            this.currentItem = this.stacks.get(this.currentIndex);
            if (this.currentItem == null) {
                this.currentItem = ItemStack.field_190927_a;
            }
        }
    }
}

