/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.image;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementThemeListener;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.HAlignment;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.VAlignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.nbt.CompoundNBT;

public class ImageElement
extends VLElement
implements IElementDraw,
IElementThemeListener {
    protected AssetID imageID;
    protected GuiTexture image;
    protected HAlignment hAlignment;
    protected VAlignment vAlignment;
    protected int xSize;
    protected int ySize;
    protected boolean render = true;

    public ImageElement(String id, AssetID imageID) {
        super(id);
        this.imageID = imageID;
        this.hAlignment = HAlignment.LEFT;
        this.vAlignment = VAlignment.TOP;
    }

    @Override
    public void load(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public int getSizeX() {
        return this.xSize;
    }

    @Override
    public int getSizeY() {
        return this.ySize;
    }

    public ImageElement setVerticalAlignment(VAlignment va) {
        this.vAlignment = va;
        return this;
    }

    public ImageElement setHorizontalAlignment(HAlignment ha) {
        this.hAlignment = ha;
        return this;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        if (!this.render) {
            return;
        }
        int xs = this.getSizeX();
        int ys = this.getSizeY();
        int xOffset = this.hAlignment.getOffset(xs);
        int yOffset = this.vAlignment.getOffset(ys);
        GuiUtils.drawGuiTexture((AbstractGui)this.getContainer().getGui(), this.image, this.getActualX() + xOffset, this.getActualY() + yOffset, xs, ys);
    }

    public void setImage(AssetID id) {
        this.imageID = id;
        if (this.image != null) {
            this.image = this.getContainer().getTheme().getTexture(id);
        }
    }

    public void setEnabled(boolean opt) {
        this.render = opt;
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
    }

    @Override
    public void onThemeChanged(Theme current) {
        this.image = current.getTexture(this.imageID);
        this.xSize = this.image.width;
        this.ySize = this.image.height;
    }
}

