/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDrawTooltip;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementInput;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementUpdate;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public abstract class IndexElement
extends VLElement
implements IElementContainer,
IElementDraw,
IElementInput {
    private Map<String, IElement> indices = Maps.newHashMap();
    private Map<String, Integer> idToNum = Maps.newHashMap();
    private Map<Integer, String> numToId = Maps.newHashMap();
    private int totalIndices = 0;
    private String currentIndex;

    public IndexElement(String id) {
        super(id);
    }

    @Override
    public final void load(CompoundNBT nbt) {
        CompoundNBT tn = nbt.func_74775_l(this.getID());
        this.setIndex(tn.func_74779_i("index"));
        this.getCurrentIndex().load(nbt);
    }

    @Override
    public final CompoundNBT save(CompoundNBT nbt) {
        CompoundNBT tn = new CompoundNBT();
        tn.func_74778_a("index", this.currentIndex);
        this.getCurrentIndex().save(tn);
        nbt.func_218657_a(this.getID(), (INBT)tn);
        return nbt;
    }

    @Override
    public int getSizeX() {
        IElement ele = this.indices.get(this.currentIndex);
        return ele != null ? ele.getSizeX() : 0;
    }

    @Override
    public int getSizeY() {
        IElement ele = this.indices.get(this.currentIndex);
        return ele != null ? ele.getSizeY() : 0;
    }

    @Override
    public Screen getGui() {
        return this.getContainer().getGui();
    }

    @Override
    public Theme getTheme() {
        return this.getContainer().getTheme();
    }

    @Override
    public int getContainerOffsetX(IElement ele) {
        return 0;
    }

    @Override
    public int getContainerOffsetY(IElement ele) {
        return 0;
    }

    @Override
    public void update() {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele != null && ele instanceof IElementUpdate) {
            ((IElementUpdate)((Object)ele)).update();
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementDraw && ((IElementDraw)((Object)ele)).isBackgroundVisible()) {
            ((IElementDraw)((Object)ele)).drawBackground(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementDraw && ((IElementDraw)((Object)ele)).isForegroundVisible()) {
            ((IElementDraw)((Object)ele)).drawForeground(mouseX, mouseY);
        }
    }

    @Override
    public void drawTooltips(int mouseX, int mouseY) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementDrawTooltip) {
            ((IElementDrawTooltip)((Object)ele)).drawTooltips(mouseX, mouseY);
        }
    }

    @Override
    public boolean emouseClicked(double mouseX, double mouseY, int mouseButton) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).emouseClicked(mouseX, mouseY, mouseButton)) {
            this.mouseClickedResponse(ele, mouseX, mouseY, mouseButton);
        }
        return false;
    }

    @Override
    public boolean emouseReleased(double mouseX, double mouseY, int mouseButton) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).emouseReleased(mouseX, mouseY, mouseButton)) {
            this.mouseReleasedResponse(ele, mouseX, mouseY, mouseButton);
        }
        return false;
    }

    @Override
    public boolean emouseDragged(double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).emouseDragged(mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd)) {
            this.mouseDraggedResponse(ele, mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd);
        }
        return false;
    }

    @Override
    public boolean emouseScrolled(double mouseX, double mouseY, double scrolled) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).emouseScrolled(mouseX, mouseY, scrolled)) {
            this.mouseScrolledResponse(ele, mouseX, mouseY, scrolled);
        }
        return false;
    }

    @Override
    public boolean ekeyPressed(int key, int scanCode, int modifiers) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).ekeyPressed(key, scanCode, modifiers)) {
            this.keyPressedResponse(ele, key, scanCode, modifiers);
        }
        return false;
    }

    @Override
    public boolean ekeyReleased(int key, int scanCode, int modifiers) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).ekeyReleased(key, scanCode, modifiers)) {
            this.keyReleasedResponse(ele, key, scanCode, modifiers);
        }
        return false;
    }

    @Override
    public boolean echarTyped(char ch, int modifiers) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).echarTyped(ch, modifiers)) {
            this.charTypedResponse(ele, ch, modifiers);
        }
        return false;
    }

    public void addIndex(VLElement index) {
        if (index != null) {
            this.indices.put(index.getID(), index);
            this.idToNum.put(index.getID(), this.totalIndices);
            this.numToId.put(this.totalIndices, index.getID());
            ++this.totalIndices;
            if (StringUtils.isNullOrEmpty(this.currentIndex)) {
                this.currentIndex = index.getID();
            }
            if (index instanceof IElementContainer) {
                ((IElementContainer)((Object)index)).initContainer();
            }
        }
    }

    public boolean hasIndex(String indexID) {
        if (StringUtils.isNullOrEmpty(indexID)) {
            return false;
        }
        return this.indices.containsKey(indexID);
    }

    public boolean setIndex(String indexID) {
        if (this.hasIndex(indexID)) {
            this.currentIndex = indexID;
            return true;
        }
        return false;
    }

    public IElement getCurrentIndex() {
        return this.indices.get(this.currentIndex);
    }

    public IElement getIndex(String index) {
        if (!this.indices.containsKey(index)) {
            return null;
        }
        return this.indices.get(index);
    }

    public boolean setIndex(int index) {
        return false;
    }

    public String getNextIndex() {
        int next = this.idToNum.get(this.currentIndex) + 1;
        if (next < this.indices.size()) {
            return this.numToId.get(next);
        }
        return this.numToId.get(0);
    }

    public String getPrevIndex() {
        int prev = this.idToNum.get(this.currentIndex) - 1;
        if (prev >= 0) {
            return this.numToId.get(prev);
        }
        return this.numToId.get(this.indices.size() - 1);
    }

    public boolean hasNextIndex() {
        return this.idToNum.get(this.currentIndex) < this.indices.size() - 1;
    }

    public boolean hasPrevIndex() {
        return this.idToNum.get(this.currentIndex) > 0;
    }

    public boolean isCurrentIndex(String index) {
        return index != null ? index.equals(this.currentIndex) : false;
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        this.getContainer().mouseClickedResponse(element, mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseReleasedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
        this.getContainer().mouseReleasedResponse(element, mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseDraggedResponse(IElement element, double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
        this.getContainer().mouseDraggedResponse(element, mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd);
    }

    @Override
    public void mouseScrolledResponse(IElement element, double mouseX, double mouseY, double scrolled) {
        this.getContainer().mouseScrolledResponse(element, mouseX, mouseY, scrolled);
    }

    @Override
    public void keyPressedResponse(IElement element, int key, int scanCode, int modifiers) {
        this.getContainer().keyPressedResponse(element, key, scanCode, modifiers);
    }

    @Override
    public void keyReleasedResponse(IElement element, int key, int scanCode, int modifiers) {
        this.getContainer().keyReleasedResponse(element, key, scanCode, modifiers);
    }

    @Override
    public void charTypedResponse(IElement element, char ch, int modifiers) {
        this.getContainer().charTypedResponse(element, ch, modifiers);
    }

    @Override
    public void onThemeChanged(Theme current) {
        GuiUtils.onThemeChangedAll(this.indices.values(), current);
    }
}

