/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementInput;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base.ElementPosition;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.ui.theme.client.ThemeRegistryClient;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;

public abstract class VLScreenContainer<CONT extends Container>
extends ContainerScreen<CONT>
implements IElementContainer,
IElementInput,
IElementDraw {
    protected PlayerEntity player;
    protected Theme theme;
    protected Map<IElement, ElementPosition> elements;
    protected List<IElement> elementList;

    public VLScreenContainer(CONT container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.player = playerInventory.field_70458_d;
        this.theme = ThemeRegistryClient.getInstance().getTheme(ThemeRegistry.DEFAULT);
        this.elements = new HashMap<IElement, ElementPosition>();
        this.elementList = new ArrayList<IElement>();
    }

    public final void addElement(IElement ele, int x, int y) {
        if (ele != null) {
            ElementPosition pos = new ElementPosition(x, y);
            this.elements.put(ele, pos);
            this.elementList.add(ele);
            ele.setOwner(this);
        }
    }

    protected abstract void addElements();

    protected final void init() {
        this.field_147003_i = (int)Math.floor((double)this.width / 2.0) - this.field_146999_f / 2;
        this.field_147009_r = (int)Math.floor((double)this.height / 2.0) - this.field_147000_g / 2;
        this.initContainer();
    }

    public final void tick() {
        super.tick();
        this.update();
    }

    public final void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected final void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(mouseX, mouseY, partialTicks);
    }

    protected final void func_146979_b(int mouseX, int mouseY) {
        this.drawForeground(mouseX, mouseY);
        this.drawTooltips(mouseX, mouseY);
    }

    public final void closeGui() {
        super.onClose();
    }

    @Override
    public final Screen getGui() {
        return this;
    }

    @Override
    public final void initContainer() {
        this.addElements();
        this.onThemeChanged(this.theme);
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    public void mouseReleasedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    public void mouseDraggedResponse(IElement element, double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
    }

    @Override
    public void mouseScrolledResponse(IElement element, double mouseX, double mouseY, double scrolled) {
    }

    @Override
    public void keyPressedResponse(IElement element, int key, int scanCode, int modifiers) {
    }

    @Override
    public void keyReleasedResponse(IElement element, int key, int scanCode, int modifiers) {
    }

    @Override
    public void charTypedResponse(IElement element, char ch, int modifiers) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        GuiUtils.mouseClickedCheckAll(this.elementList, mouseX, mouseY, button, this);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean emouseClicked(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        GuiUtils.mouseReleasedCheckAll(this.elementList, mouseX, mouseY, button, this);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean emouseReleased(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXScroll, double mouseYScroll) {
        GuiUtils.mouseDraggedCheckAll(this.elementList, mouseX, mouseY, mouseButton, mouseXScroll, mouseYScroll, this);
        return super.mouseDragged(mouseX, mouseY, mouseButton, mouseXScroll, mouseYScroll);
    }

    @Override
    public boolean emouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXScroll, double mouseYScroll) {
        return false;
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        GuiUtils.mouseScrolledCheckAll(this.elementList, p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_, this);
        return super.mouseScrolled(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    @Override
    public boolean emouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double scrolled) {
        return false;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        GuiUtils.keyPressedCheckAll(this.elementList, p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_, this);
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    public boolean ekeyPressed(int key, int scanCode, int modifiers) {
        return false;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        GuiUtils.keyReleasedCheckAll(this.elementList, keyCode, scanCode, modifiers, this);
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean ekeyReleased(int key, int scanCode, int modifiers) {
        return false;
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        GuiUtils.charTypedCheckAll(this.elementList, p_charTyped_1_, p_charTyped_2_, this);
        return super.charTyped(p_charTyped_1_, p_charTyped_2_);
    }

    @Override
    public boolean echarTyped(char ch, int modifiers) {
        return false;
    }

    @Override
    public final int getContainerOffsetX(IElement ele) {
        if (this.elements.containsKey(ele)) {
            return this.elements.get(ele).getX();
        }
        return 0;
    }

    @Override
    public final int getContainerOffsetY(IElement ele) {
        if (this.elements.containsKey(ele)) {
            return this.elements.get(ele).getY();
        }
        return 0;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawBackground(this.elementList, mouseX, mouseY, partialTicks, this);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        GuiUtils.drawForeground(this.elementList, mouseX, mouseY, this);
    }

    @Override
    public void drawTooltips(int mouseX, int mouseY) {
        GuiUtils.drawTooltips(this.elementList, mouseX, mouseY, this);
    }

    @Override
    public final String getID() {
        return this.getRawID();
    }

    @Override
    public String getRawID() {
        return "main";
    }

    @Override
    public final int getActualX() {
        return this.field_147003_i;
    }

    @Override
    public final int getActualY() {
        return this.field_147009_r;
    }

    @Override
    public final int getSizeX() {
        return this.field_146999_f;
    }

    @Override
    public final int getSizeY() {
        return this.field_147000_g;
    }

    @Override
    public final void onThemeChanged(Theme current) {
        GuiUtils.onThemeChangedAll(this.elementList, current);
    }

    @Override
    public final Theme getTheme() {
        return this.theme;
    }

    @Override
    public void update() {
        GuiUtils.updateAll(this.elementList);
    }
}

