/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json.config.property.properties;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropBase;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropParserBase;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropParserRegistry;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PropMap
extends PropBase<Map<String, PropBase>> {
    public static final PropMapParser PARSER = new PropMapParser();

    public PropMap() {
        super(new LinkedHashMap());
    }

    public void putAll(PropMap prop) {
        if (prop == null) {
            return;
        }
        ((Map)this.data).putAll((Map)prop.data);
    }

    public void put(PropBase prop) throws Exception {
        if (prop == null) {
            throw new NullPointerException("Prop is null");
        }
        if (StringUtils.isNullOrEmpty(prop.getId())) {
            throw new Exception("Prop doesnt contain id");
        }
        if (((Map)this.data).containsKey(prop.getMapKey())) {
            throw new Exception("Map contains Prop with same key already");
        }
        ((Map)this.data).put(prop.getMapKey(), prop);
    }

    public PropBase get(String mapKey) {
        if (StringUtils.isNullOrEmpty(mapKey)) {
            return null;
        }
        return (PropBase)((Map)this.data).get(mapKey);
    }

    public PropBase getOrDefault(String name, PropBase defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("Default value is null");
        }
        PropBase prop = this.get(defaultValue.generateKey(name));
        if (prop == null) {
            prop = defaultValue;
            prop.setId(name);
            if (prop != null) {
                try {
                    this.put(prop);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        prop.setDefaultValue(defaultValue.getValue());
        return prop;
    }

    public String toString() {
        String r = "";
        for (String string : ((Map)this.data).keySet()) {
            r = r + "[" + string + ":" + ((PropBase)((Map)this.data).get(string)).toString() + "]";
        }
        return r;
    }

    @Override
    protected Map<String, PropBase> validateData(Map<String, PropBase> data) {
        data.forEach((str, prop) -> prop.validateData());
        return data;
    }

    @Override
    @NotNull
    public PropParserBase getParser() {
        return PARSER;
    }

    public static class PropMapParser
    extends PropParserBase<PropMap> {
        public PropMapParser() {
            super("ma");
        }

        @Override
        public PropMap fromJson(JsonElement json) throws Exception {
            JsonObject jobj = (JsonObject)json;
            PropMap pm = new PropMap();
            for (Map.Entry ent : jobj.entrySet()) {
                String key = (String)ent.getKey();
                JsonElement ele = (JsonElement)ent.getValue();
                String[] data = key.split(":");
                if (data.length < 2) continue;
                String pre = data[0];
                String id = data[1];
                PropParserBase pp = PropParserRegistry.getGlobalInstance().getParser(pre);
                if (pp == null) continue;
                PropBase pb = ((PropBase)pp.fromJson(ele)).setId(id);
                ((Map)pm.data).put(pb.generateKey(id), pb);
            }
            return pm;
        }

        @Override
        public JsonElement toJson(PropMap prop) throws Exception {
            JsonObject jobj = new JsonObject();
            for (PropBase pb : ((Map)prop.data).values()) {
                PropParserBase pp = pb.getParser();
                if (!pb.isEnabled()) continue;
                String jsonKey = pb.getMapKey();
                String extra = pb.getExtra();
                if (!StringUtils.isNullOrEmpty(extra)) {
                    jsonKey = jsonKey + ":" + extra;
                }
                jobj.add(jsonKey, pp.toJson(pb));
            }
            return jobj;
        }

        @Override
        public List<String> getLocalizedDocumentation(PropMap prop) {
            ArrayList data = Lists.newArrayList();
            data.add("\u250f\u2578" + prop.getMapKey());
            List<String> mapDocumentation = prop.getDocumentation();
            for (String string : mapDocumentation) {
                data.add("\u2523> ");
            }
            Map propData = (Map)prop.getValue();
            for (PropBase propEntry : propData.values()) {
                List<String> propEntryData = propEntry.getParser().getLocalizedDocumentation(propEntry);
                for (String string : propEntryData) {
                    data.add('\u2503' + string);
                }
            }
            data.add("\u2517\u2578");
            return data;
        }
    }
}

