/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.client;

import com.github.commoble.tubesreloaded.common.blocks.tube.ItemInTubeWrapper;
import com.github.commoble.tubesreloaded.common.blocks.tube.TubeTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TubeTileEntityRenderer
extends TileEntityRenderer<TubeTileEntity> {
    public TubeTileEntityRenderer(TileEntityRendererDispatcher p_i226006_1_) {
        super(p_i226006_1_);
    }

    public void render(TubeTileEntity tube, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int intA, int intB) {
        if (!tube.inventory.isEmpty()) {
            for (ItemInTubeWrapper wrapper : tube.inventory) {
                this.renderWrapper(tube, wrapper, partialTicks, matrix, buffer, intA);
            }
        }
        if (!tube.incoming_wrapper_buffer.isEmpty()) {
            for (ItemInTubeWrapper wrapper : tube.incoming_wrapper_buffer) {
                this.renderWrapper(tube, wrapper, partialTicks, matrix, buffer, intA);
            }
        }
    }

    protected int getModelCount(ItemStack stack) {
        int i = 1;
        if (stack.func_190916_E() > 48) {
            i = 5;
        } else if (stack.func_190916_E() > 32) {
            i = 4;
        } else if (stack.func_190916_E() > 16) {
            i = 3;
        } else if (stack.func_190916_E() > 1) {
            i = 2;
        }
        return i;
    }

    public void renderWrapper(TubeTileEntity tube, ItemInTubeWrapper wrapper, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int intA) {
        float zStart;
        float yStart;
        float xStart;
        float zEnd;
        float yEnd;
        float xEnd;
        Direction nextMove = wrapper.remainingMoves.peek();
        if (nextMove == null) {
            return;
        }
        ItemStack itemstack = wrapper.stack;
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        Random random = new Random();
        Item item = itemstack.func_77973_b();
        int i = itemstack.func_190926_b() ? 187 : Item.func_150891_b((Item)item) + itemstack.func_77952_i();
        random.setSeed(i);
        matrix.func_227860_a_();
        int renderedItemCount = this.getModelCount(itemstack);
        float lerpFactor = ((float)wrapper.ticksElapsed + partialTicks) / (float)wrapper.maximumDurationInTube;
        if (wrapper.freshlyInserted) {
            xEnd = 0.0f;
            yEnd = 0.0f;
            zEnd = 0.0f;
            xStart = xEnd - (float)nextMove.func_82601_c();
            yStart = yEnd - (float)nextMove.func_96559_d();
            zStart = zEnd - (float)nextMove.func_82599_e();
        } else {
            xStart = 0.0f;
            yStart = 0.0f;
            zStart = 0.0f;
            xEnd = xStart + (float)nextMove.func_82601_c();
            yEnd = yStart + (float)nextMove.func_96559_d();
            zEnd = zStart + (float)nextMove.func_82599_e();
        }
        float xLerp = MathHelper.func_219799_g((float)lerpFactor, (float)xStart, (float)xEnd);
        float yLerp = MathHelper.func_219799_g((float)lerpFactor, (float)yStart, (float)yEnd);
        float zLerp = MathHelper.func_219799_g((float)lerpFactor, (float)zStart, (float)zEnd);
        itemRenderer.field_77023_b -= 50.0f;
        for (int currentModelIndex = 0; currentModelIndex < renderedItemCount; ++currentModelIndex) {
            matrix.func_227860_a_();
            float xAdjustment = 0.0f;
            float yAdjustment = 0.0f;
            float zAdjustment = 0.0f;
            if (currentModelIndex > 0) {
                xAdjustment = (random.nextFloat() * 2.0f - 1.0f) * 0.01f;
                yAdjustment = (random.nextFloat() * 2.0f - 1.0f) * 0.01f;
                zAdjustment = (random.nextFloat() * 2.0f - 1.0f) * 0.01f;
            }
            float xTranslate = xLerp + xAdjustment + 0.5f;
            float yTranslate = yLerp + yAdjustment + 0.4375f;
            float zTranslate = zLerp + zAdjustment + 0.5f;
            matrix.func_227861_a_((double)xTranslate, (double)yTranslate, (double)zTranslate);
            matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
            itemRenderer.func_229110_a_(itemstack, ItemCameraTransforms.TransformType.GROUND, intA, OverlayTexture.field_229196_a_, matrix, buffer);
            matrix.func_227865_b_();
        }
        itemRenderer.field_77023_b += 50.0f;
        matrix.func_227865_b_();
    }
}

