/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.net;

import com.feed_the_beast.mods.ftbchunks.FTBChunks;
import com.feed_the_beast.mods.ftbchunks.api.PrivacyMode;
import com.feed_the_beast.mods.ftbchunks.api.Waypoint;
import com.feed_the_beast.mods.ftbchunks.api.WaypointType;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkPlayerDataImpl;
import com.feed_the_beast.mods.ftbchunks.impl.FTBChunksAPIImpl;
import com.feed_the_beast.mods.ftbchunks.net.FTBChunksNet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class SendWaypointsPacket {
    public List<Waypoint> waypoints;

    public static void send(ServerPlayerEntity player) {
        ClaimedChunkPlayerDataImpl data = FTBChunksAPIImpl.manager.getData(player);
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        for (ClaimedChunkPlayerDataImpl d : FTBChunksAPIImpl.manager.playerData.values()) {
            for (Waypoint w : d.waypoints.values()) {
                if (d != data && w.privacy != PrivacyMode.PUBLIC && (w.privacy != PrivacyMode.ALLIES || !w.playerData.isAlly(player))) continue;
                Waypoint w1 = w.copy();
                if (d != data) {
                    w1.owner = d.getName();
                }
                waypoints.add(w1);
            }
        }
        FTBChunksNet.MAIN.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SendWaypointsPacket(waypoints));
    }

    public SendWaypointsPacket(List<Waypoint> w) {
        this.waypoints = w;
    }

    SendWaypointsPacket(PacketBuffer buf) {
        int s = buf.func_150792_a();
        this.waypoints = new ArrayList<Waypoint>(s);
        for (int i = 0; i < s; ++i) {
            Waypoint w = new Waypoint(null, new UUID(buf.readLong(), buf.readLong()));
            w.name = buf.func_150789_c(100);
            w.owner = buf.func_150789_c(100);
            w.dimension = DimensionType.func_186069_a((int)buf.func_150792_a());
            w.x = buf.func_150792_a();
            w.y = buf.func_150792_a();
            w.z = buf.func_150792_a();
            w.color = buf.readInt();
            w.privacy = PrivacyMode.VALUES[buf.readByte()];
            w.type = WaypointType.VALUES[buf.readByte()];
            this.waypoints.add(w);
        }
    }

    void write(PacketBuffer buf) {
        buf.func_150787_b(this.waypoints.size());
        for (Waypoint w : this.waypoints) {
            buf.writeLong(w.id.getMostSignificantBits());
            buf.writeLong(w.id.getLeastSignificantBits());
            buf.func_211400_a(w.name, 100);
            buf.func_211400_a(w.owner, 100);
            buf.func_150787_b(w.dimension.func_186068_a());
            buf.func_150787_b(w.x);
            buf.func_150787_b(w.y);
            buf.func_150787_b(w.z);
            buf.writeInt(w.color);
            buf.writeByte(w.privacy.ordinal());
            buf.writeByte(w.type.ordinal());
        }
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> FTBChunks.instance.proxy.updateWaypoints(this));
        context.get().setPacketHandled(true);
    }
}

