/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.net;

import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkPlayerDataImpl;
import com.feed_the_beast.mods.ftbchunks.impl.FTBChunksAPIImpl;
import com.feed_the_beast.mods.ftbchunks.net.SendWaypointsPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class DeleteWaypointPacket {
    public final UUID id;

    public DeleteWaypointPacket(UUID w) {
        this.id = w;
    }

    DeleteWaypointPacket(PacketBuffer buf) {
        this.id = new UUID(buf.readLong(), buf.readLong());
    }

    void write(PacketBuffer buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity p = ((NetworkEvent.Context)context.get()).getSender();
            ClaimedChunkPlayerDataImpl data = FTBChunksAPIImpl.manager.getData(p);
            data.waypoints.remove(this.id);
            data.save();
            SendWaypointsPacket.send(p);
        });
        context.get().setPacketHandled(true);
    }
}

