/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.net;

import com.feed_the_beast.mods.ftbchunks.api.Waypoint;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkPlayerDataImpl;
import com.feed_the_beast.mods.ftbchunks.impl.FTBChunksAPIImpl;
import com.feed_the_beast.mods.ftbchunks.net.SendWaypointsPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ChangeWaypointColorPacket {
    public final UUID id;
    public final int color;

    public ChangeWaypointColorPacket(UUID w, int c) {
        this.id = w;
        this.color = c;
    }

    ChangeWaypointColorPacket(PacketBuffer buf) {
        this.id = new UUID(buf.readLong(), buf.readLong());
        this.color = buf.readInt();
    }

    void write(PacketBuffer buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        buf.writeInt(this.color);
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity p = ((NetworkEvent.Context)context.get()).getSender();
            ClaimedChunkPlayerDataImpl data = FTBChunksAPIImpl.manager.getData(p);
            Waypoint w = data.waypoints.get(this.id);
            if (w != null) {
                w.color = this.color;
                data.save();
                SendWaypointsPacket.send(p);
            }
        });
        context.get().setPacketHandled(true);
    }
}

