/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.impl.map;

import com.feed_the_beast.mods.ftbchunks.api.ChunkDimPos;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkManagerImpl;
import com.feed_the_beast.mods.ftbchunks.impl.map.CanSeeMap;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapChunk;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapDimension;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapTask;
import com.feed_the_beast.mods.ftbchunks.impl.map.ReloadChunkTask;
import com.feed_the_beast.mods.ftbchunks.impl.map.SendChunkTask;
import com.feed_the_beast.mods.ftbchunks.impl.map.XZ;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class MapManager {
    public final ClaimedChunkManagerImpl manager;
    public final Map<DimensionType, MapDimension> dimensions;
    public final ArrayDeque<MapTask> taskQueue;
    public long taskQueueTicks;

    public MapManager(ClaimedChunkManagerImpl m) {
        this.manager = m;
        this.dimensions = new HashMap<DimensionType, MapDimension>();
        this.taskQueue = new ArrayDeque();
        this.taskQueueTicks = 0L;
    }

    public MapDimension getDimension(DimensionType dim) {
        return this.dimensions.computeIfAbsent(dim, d -> new MapDimension(this, (DimensionType)d));
    }

    public MapChunk getChunk(DimensionType dim, XZ chunkPos) {
        return this.getDimension(dim).getRegion(XZ.regionFromChunk(chunkPos.x, chunkPos.z)).access().getChunk(chunkPos);
    }

    public MapChunk getChunk(ChunkDimPos pos) {
        return this.getDimension(pos.dimension).getRegion(XZ.regionFromChunk(pos.x, pos.z)).access().getChunk(XZ.of(pos.x, pos.z));
    }

    public void queue(MapTask task) {
        this.taskQueue.addLast(task);
    }

    public void queueUpdate(World world, XZ pos, ReloadChunkTask.Callback callback) {
        this.queue(new ReloadChunkTask(world, pos, callback));
    }

    public void queueUpdate(World world, XZ pos, ServerPlayerEntity player) {
        this.queueUpdate(world, pos, (ReloadChunkTask task, boolean changed) -> task.send(new CanSeeMap(player)));
    }

    public void queueSend(World world, XZ pos, Predicate<ServerPlayerEntity> sendTo) {
        this.queue(new SendChunkTask(world, pos, sendTo));
    }
}

