/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.client.map;

import com.feed_the_beast.mods.ftbchunks.FTBChunks;
import com.feed_the_beast.mods.ftbchunks.client.map.ClientMapChunk;
import com.feed_the_beast.mods.ftbchunks.client.map.ClientMapDimension;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapTask;
import com.feed_the_beast.mods.ftbchunks.impl.map.XZ;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.NativeImage;

public class ClientMapRegion
implements MapTask {
    private static final int NO_CHUNK = NativeImage.func_227787_a_((int)255, (int)0, (int)0, (int)0);
    public final ClientMapDimension dimension;
    public final XZ pos;
    public final Map<XZ, ClientMapChunk> chunks;
    private NativeImage image;
    public boolean saveImage;

    public ClientMapRegion(ClientMapDimension d, XZ p) {
        this.dimension = d;
        this.pos = p;
        this.chunks = new HashMap<XZ, ClientMapChunk>();
        this.image = null;
        this.saveImage = false;
    }

    public ClientMapRegion load() {
        if (Files.notExists(this.dimension.directory, new LinkOption[0])) {
            return this;
        }
        Path file = this.dimension.directory.resolve(this.pos.x + "," + this.pos.z + ",map.png");
        if (Files.notExists(file, new LinkOption[0])) {
            return this;
        }
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            this.image = NativeImage.func_195713_a((InputStream)is);
            if (this.image.func_195702_a() == 512 && this.image.func_195714_b() == 512) {
                for (int cz = 0; cz < 32; ++cz) {
                    for (int cx = 0; cx < 32; ++cx) {
                        if (this.image.func_195709_a(cx * 16, cz * 16) == NO_CHUNK) continue;
                        ClientMapChunk chunk = new ClientMapChunk(this, XZ.of(cx, cz));
                        this.chunks.put(chunk.pos, chunk);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        FTBChunks.LOGGER.debug("Loaded client region " + this.pos + " - " + this.chunks.size() + " chunks");
        return this;
    }

    public NativeImage getImage() {
        if (this.image == null) {
            this.image = new NativeImage(NativeImage.PixelFormat.RGBA, 512, 512, true);
            this.image.func_195715_a(0, 0, 512, 512, NO_CHUNK);
            this.saveImage = true;
        }
        return this.image;
    }

    public ClientMapChunk getChunk(XZ pos) {
        if (pos.x != (pos.x & 0x1F) || pos.z != (pos.z & 0x1F)) {
            pos = XZ.of(pos.x & 0x1F, pos.z & 0x1F);
        }
        return this.chunks.computeIfAbsent(pos, p -> new ClientMapChunk(this, (XZ)p));
    }

    public void release() {
        if (this.image != null) {
            this.image.close();
            this.image = null;
        }
    }

    @Override
    public void run() {
        try {
            if (Files.notExists(this.dimension.directory, new LinkOption[0])) {
                Files.createDirectories(this.dimension.directory, new FileAttribute[0]);
            }
            this.getImage().func_209270_a(this.dimension.directory.resolve(this.pos.x + "," + this.pos.z + ",map.png"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

