/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.client;

import com.feed_the_beast.mods.ftbchunks.api.Waypoint;
import com.feed_the_beast.mods.ftbchunks.client.FTBChunksClient;
import com.feed_the_beast.mods.ftbchunks.client.LargeMapScreen;
import com.feed_the_beast.mods.ftbchunks.client.PlayerButton;
import com.feed_the_beast.mods.ftbchunks.client.RegionMapButton;
import com.feed_the_beast.mods.ftbchunks.client.WaypointButton;
import com.feed_the_beast.mods.ftbchunks.impl.map.XZ;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.util.math.MathHelper;

public class RegionMapPanel
extends Panel {
    public final LargeMapScreen largeMap;
    public double regionX = 0.0;
    public double regionZ = 0.0;
    public int regionMinX;
    public int regionMinZ;
    public int regionMaxX;
    public int regionMaxZ;
    public int blockX = 0;
    public int blockZ = 0;

    public RegionMapPanel(LargeMapScreen panel) {
        super((Panel)panel);
        this.largeMap = panel;
    }

    public void updateMinMax() {
        this.regionMinX = Integer.MAX_VALUE;
        this.regionMinZ = Integer.MAX_VALUE;
        this.regionMaxX = Integer.MIN_VALUE;
        this.regionMaxZ = Integer.MIN_VALUE;
        for (Widget w : this.widgets) {
            if (!(w instanceof RegionMapButton)) continue;
            int qx = ((RegionMapButton)w).pos.x;
            int qy = ((RegionMapButton)w).pos.z;
            this.regionMinX = Math.min(this.regionMinX, qx);
            this.regionMinZ = Math.min(this.regionMinZ, qy);
            this.regionMaxX = Math.max(this.regionMaxX, qx);
            this.regionMaxZ = Math.max(this.regionMaxZ, qy);
        }
        if (this.regionMinX == Integer.MAX_VALUE) {
            this.regionMaxZ = 0;
            this.regionMaxX = 0;
            this.regionMinZ = 0;
            this.regionMinX = 0;
        }
        this.regionMinX -= 100;
        this.regionMinZ -= 100;
        this.regionMaxX += 101;
        this.regionMaxZ += 101;
    }

    public void scrollTo(double x, double y) {
        this.updateMinMax();
        double dx = this.regionMaxX - this.regionMinX;
        double dy = this.regionMaxZ - this.regionMinZ;
        this.setScrollX((x - (double)this.regionMinX) / dx * (double)this.largeMap.scrollWidth - (double)this.width / 2.0);
        this.setScrollY((y - (double)this.regionMinZ) / dy * (double)this.largeMap.scrollHeight - (double)this.height / 2.0);
    }

    public void resetScroll() {
        this.alignWidgets();
        this.setScrollX((double)(this.largeMap.scrollWidth - this.width) / 2.0);
        this.setScrollY((double)(this.largeMap.scrollHeight - this.height) / 2.0);
    }

    public void addWidgets() {
        FTBChunksClient.saveAllRegions();
        try {
            if (Files.exists(this.largeMap.dimension.directory, new LinkOption[0])) {
                Files.list(this.largeMap.dimension.directory).map(path -> path.getFileName().toString()).filter(name -> name.endsWith(".png")).map(name -> name.split(",")).filter(name -> ((String[])name).length == 3).map(name -> new RegionMapButton(this, XZ.of(Integer.parseInt(name[0]), Integer.parseInt(name[1])))).forEach(arg_0 -> ((RegionMapPanel)this).add(arg_0));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (Waypoint waypoint : this.largeMap.dimension.waypoints) {
            this.add(new WaypointButton(this, waypoint));
        }
        for (AbstractClientPlayerEntity player : Minecraft.func_71410_x().field_71441_e.func_217369_A()) {
            if (player.field_71093_bK != this.largeMap.dimension.dimension) continue;
            this.add(new PlayerButton(this, player));
        }
        this.alignWidgets();
    }

    public void alignWidgets() {
        this.largeMap.scrollWidth = 0;
        this.largeMap.scrollHeight = 0;
        this.updateMinMax();
        int z = this.largeMap.getRegionButtonSize();
        this.largeMap.scrollWidth = (this.regionMaxX - this.regionMinX) * z;
        this.largeMap.scrollHeight = (this.regionMaxZ - this.regionMinZ) * z;
        for (Widget w : this.widgets) {
            double y;
            double x;
            double qy;
            double qx;
            if (w instanceof RegionMapButton) {
                qx = ((RegionMapButton)w).pos.x;
                qy = ((RegionMapButton)w).pos.z;
                double qw = 1.0;
                double qh = 1.0;
                double x2 = (qx - (double)this.regionMinX) * (double)z;
                double y2 = (qy - (double)this.regionMinZ) * (double)z;
                w.setPosAndSize((int)x2, (int)y2, (int)((double)z * qw), (int)((double)z * qh));
                continue;
            }
            if (w instanceof WaypointButton) {
                qx = (double)((WaypointButton)w).waypoint.x / 512.0;
                qy = (double)((WaypointButton)w).waypoint.z / 512.0;
                int s = Math.max(4, z / 128);
                x = (qx - (double)this.regionMinX) * (double)z - (double)s / 2.0;
                y = (qy - (double)this.regionMinZ) * (double)z - (double)s / 2.0;
                w.setPosAndSize((int)x, (int)y, s, s);
                continue;
            }
            if (!(w instanceof PlayerButton)) continue;
            qx = ((PlayerButton)w).playerX / 512.0;
            qy = ((PlayerButton)w).playerZ / 512.0;
            int s = Math.max(4, z / 128);
            x = (qx - (double)this.regionMinX) * (double)z - (double)s / 2.0;
            y = (qy - (double)this.regionMinZ) * (double)z - (double)s / 2.0;
            w.setPosAndSize((int)x, (int)y, s, s);
        }
        this.setPosAndSize(0, 0, this.parent.width, this.parent.height);
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        super.draw(theme, x, y, w, h);
        int dx = this.regionMaxX - this.regionMinX;
        int dy = this.regionMaxZ - this.regionMinZ;
        double px = (double)this.getX() - this.getScrollX();
        double py = (double)this.getY() - this.getScrollY();
        this.regionX = ((double)this.parent.getMouseX() - px) / (double)this.largeMap.scrollWidth * (double)dx + (double)this.regionMinX;
        this.regionZ = ((double)this.parent.getMouseY() - py) / (double)this.largeMap.scrollHeight * (double)dy + (double)this.regionMinZ;
        this.blockX = MathHelper.func_76128_c((double)(this.regionX * 512.0));
        this.blockZ = MathHelper.func_76128_c((double)(this.regionZ * 512.0));
    }

    public boolean mousePressed(MouseButton button) {
        if (super.mousePressed(button)) {
            return true;
        }
        if (button.isLeft() && this.isMouseOver()) {
            this.largeMap.prevMouseX = this.getMouseX();
            this.largeMap.prevMouseY = this.getMouseY();
            this.largeMap.grabbed = 1;
            return true;
        }
        return false;
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        this.largeMap.grabbed = 0;
    }

    public boolean scrollPanel(double scroll) {
        if (this.isMouseOver()) {
            this.largeMap.addZoom(scroll);
            return true;
        }
        return false;
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        super.drawBackground(theme, x, y, w, h);
    }
}

