/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.KeyModifiers;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.feed_the_beast.mods.ftbguilibrary.widget.MismatchingParentPanelException;
import com.feed_the_beast.mods.ftbguilibrary.widget.PanelScrollBar;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetLayout;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public abstract class Panel
extends Widget {
    public final List<Widget> widgets = new ArrayList<Widget>();
    private double scrollX = 0.0;
    private double scrollY = 0.0;
    private int offsetX = 0;
    private int offsetY = 0;
    private boolean unicode = false;
    private boolean onlyRenderWidgetsInside = true;
    private boolean onlyInteractWithWidgetsInside = true;
    private double scrollStep = 20.0;
    private int contentWidth = -1;
    private int contentHeight = -1;
    public int contentWidthExtra;
    public int contentHeightExtra;
    public PanelScrollBar attachedScrollbar = null;

    public Panel(Panel panel) {
        super(panel);
    }

    public boolean getUnicode() {
        return this.unicode;
    }

    public void setUnicode(boolean value) {
        this.unicode = value;
    }

    public boolean getOnlyRenderWidgetsInside() {
        return this.onlyRenderWidgetsInside;
    }

    public void setOnlyRenderWidgetsInside(boolean value) {
        this.onlyRenderWidgetsInside = value;
    }

    public boolean getOnlyInteractWithWidgetsInside() {
        return this.onlyInteractWithWidgetsInside;
    }

    public void setOnlyInteractWithWidgetsInside(boolean value) {
        this.onlyInteractWithWidgetsInside = value;
    }

    public abstract void addWidgets();

    public abstract void alignWidgets();

    public void clearWidgets() {
        this.widgets.clear();
    }

    public void refreshWidgets() {
        this.contentHeight = -1;
        this.contentWidth = -1;
        this.clearWidgets();
        Theme theme = this.getGui().getTheme();
        theme.pushFontUnicode(this.getUnicode());
        try {
            this.addWidgets();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (Widget widget : this.widgets) {
            if (!(widget instanceof Panel)) continue;
            ((Panel)widget).refreshWidgets();
        }
        this.alignWidgets();
        theme.popFontUnicode();
    }

    public void add(Widget widget) {
        if (widget.parent != this) {
            throw new MismatchingParentPanelException(this, widget);
        }
        this.widgets.add(widget);
        this.contentHeight = -1;
        this.contentWidth = -1;
    }

    public void addAll(Iterable<? extends Widget> list) {
        for (Widget widget : list) {
            this.add(widget);
        }
    }

    public final int align(WidgetLayout layout) {
        return layout.align(this);
    }

    @Override
    public int getX() {
        return super.getX() + this.offsetX;
    }

    @Override
    public int getY() {
        return super.getY() + this.offsetY;
    }

    public int getContentWidth() {
        if (this.contentWidth == -1) {
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            for (Widget widget : this.widgets) {
                if (widget.posX < minX) {
                    minX = widget.posX;
                }
                if (widget.posX + widget.width <= maxX) continue;
                maxX = widget.posX + widget.width;
            }
            this.contentWidth = maxX - minX + this.contentWidthExtra;
        }
        return this.contentWidth;
    }

    public int getContentHeight() {
        if (this.contentHeight == -1) {
            int minY = Integer.MAX_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (Widget widget : this.widgets) {
                if (widget.posY < minY) {
                    minY = widget.posY;
                }
                if (widget.posY + widget.height <= maxY) continue;
                maxY = widget.posY + widget.height;
            }
            this.contentHeight = maxY - minY + this.contentHeightExtra;
        }
        return this.contentHeight;
    }

    public void setOffset(boolean flag) {
        if (flag) {
            this.offsetX = (int)(-this.scrollX);
            this.offsetY = (int)(-this.scrollY);
        } else {
            this.offsetY = 0;
            this.offsetX = 0;
        }
    }

    public boolean isOffset() {
        return this.offsetX != 0 || this.offsetY != 0;
    }

    public void setScrollX(double scroll) {
        this.scrollX = scroll;
    }

    public void setScrollY(double scroll) {
        this.scrollY = scroll;
    }

    public double getScrollX() {
        return this.scrollX;
    }

    public double getScrollY() {
        return this.scrollY;
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        boolean renderInside = this.getOnlyRenderWidgetsInside();
        theme.pushFontUnicode(this.getUnicode());
        this.drawBackground(theme, x, y, w, h);
        if (renderInside) {
            GuiHelper.pushScissor(this.getScreen(), x, y, w, h);
        }
        this.setOffset(true);
        this.drawOffsetBackground(theme, x + this.offsetX, y + this.offsetY, w, h);
        for (int i = 0; i < this.widgets.size(); ++i) {
            Widget widget = this.widgets.get(i);
            if (!widget.shouldDraw() || renderInside && !widget.collidesWith(x, y, w, h)) continue;
            this.drawWidget(theme, widget, i, x + this.offsetX, y + this.offsetY, w, h);
        }
        this.setOffset(false);
        if (renderInside) {
            GuiHelper.popScissor(this.getScreen());
        }
        theme.popFontUnicode();
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
    }

    public void drawOffsetBackground(Theme theme, int x, int y, int w, int h) {
    }

    public void drawWidget(Theme theme, Widget widget, int index, int x, int y, int w, int h) {
        int wx = widget.getX();
        int wy = widget.getY();
        int ww = widget.width;
        int wh = widget.height;
        widget.draw(theme, wx, wy, ww, wh);
        if (Theme.renderDebugBoxes) {
            Color4I col = Color4I.rgb(Color.HSBtoRGB((float)(widget.hashCode() & 0xFF) / 255.0f, 1.0f, 1.0f));
            GuiHelper.drawHollowRect(wx, wy, ww, wh, col.withAlpha(150), false);
            col.withAlpha(30).draw(wx + 1, wy + 1, ww - 2, wh - 2);
        }
    }

    @Override
    public void addMouseOverText(List<String> list) {
        if (!this.shouldAddMouseOverText() || this.getOnlyInteractWithWidgetsInside() && !this.isMouseOver()) {
            return;
        }
        Theme theme = this.getGui().getTheme();
        theme.pushFontUnicode(this.getUnicode());
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.shouldAddMouseOverText()) continue;
            widget.addMouseOverText(list);
            if (!Theme.renderDebugBoxes) continue;
            list.add(TextFormatting.DARK_GRAY + widget.toString() + "#" + (i + 1) + ": " + widget.width + "x" + widget.height);
        }
        this.setOffset(false);
        theme.popFontUnicode();
    }

    @Override
    public void updateMouseOver(int mouseX, int mouseY) {
        super.updateMouseOver(mouseX, mouseY);
        this.setOffset(true);
        for (Widget widget : this.widgets) {
            widget.updateMouseOver(mouseX, mouseY);
        }
        this.setOffset(false);
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.getOnlyInteractWithWidgetsInside() && !this.isMouseOver()) {
            return false;
        }
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.mousePressed(button)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    @Override
    public void mouseReleased(MouseButton button) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled()) continue;
            widget.mouseReleased(button);
        }
        this.setOffset(false);
    }

    @Override
    public boolean mouseScrolled(double scroll) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.mouseScrolled(scroll)) continue;
            this.setOffset(false);
            return true;
        }
        boolean scrollPanel = this.scrollPanel(scroll);
        this.setOffset(false);
        return scrollPanel;
    }

    public boolean scrollPanel(double scroll) {
        if (this.attachedScrollbar != null || !this.isMouseOver()) {
            return false;
        }
        if (this.isDefaultScrollVertical() != Panel.isShiftKeyDown()) {
            return this.movePanelScroll(0.0, -this.getScrollStep() * scroll);
        }
        return this.movePanelScroll(-this.getScrollStep() * scroll, 0.0);
    }

    public boolean movePanelScroll(double dx, double dy) {
        int h;
        int w;
        if (dx == 0.0 && dy == 0.0) {
            return false;
        }
        double sx = this.getScrollX();
        double sy = this.getScrollY();
        if (dx != 0.0 && (w = this.getContentWidth()) > this.width) {
            this.setScrollX(MathHelper.func_151237_a((double)(sx + dx), (double)0.0, (double)(w - this.width)));
        }
        if (dy != 0.0 && (h = this.getContentHeight()) > this.height) {
            this.setScrollY(MathHelper.func_151237_a((double)(sy + dy), (double)0.0, (double)(h - this.height)));
        }
        return this.getScrollX() != sx || this.getScrollY() != sy;
    }

    public boolean isDefaultScrollVertical() {
        return true;
    }

    public void setScrollStep(double s) {
        this.scrollStep = s;
    }

    public double getScrollStep() {
        return this.scrollStep;
    }

    @Override
    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.keyPressed(key)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    @Override
    public void keyReleased(Key key) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled()) continue;
            widget.keyReleased(key);
        }
        this.setOffset(false);
    }

    @Override
    public boolean charTyped(char c, KeyModifiers modifiers) {
        if (super.charTyped(c, modifiers)) {
            return true;
        }
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.charTyped(c, modifiers)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    @Override
    public void onClosed() {
        for (Widget widget : this.widgets) {
            widget.onClosed();
        }
    }

    @Nullable
    public Widget getWidget(int index) {
        return index < 0 || index >= this.widgets.size() ? null : this.widgets.get(index);
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse() {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Object object;
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.isMouseOver() || (object = widget.getIngredientUnderMouse()) == null) continue;
            this.setOffset(false);
            return object;
        }
        this.setOffset(false);
        return null;
    }

    @Override
    public void tick() {
        this.setOffset(true);
        for (Widget widget : this.widgets) {
            if (!widget.isEnabled()) continue;
            widget.tick();
        }
        this.setOffset(false);
    }

    public boolean isMouseOverAnyWidget() {
        for (Widget widget : this.widgets) {
            if (!widget.isMouseOver()) continue;
            return true;
        }
        return false;
    }
}

