/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.utils.ClientUtils;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import javax.annotation.Nullable;

public interface IOpenableGui
extends Runnable {
    public void openGui();

    default public void openGuiLater() {
        ClientUtils.runLater(this);
    }

    default public void closeGui() {
        this.closeGui(true);
    }

    default public void closeGui(boolean openPrevScreen) {
    }

    default public void openContextMenu(@Nullable Panel panel) {
        if (this instanceof Widget) {
            ((Widget)this).getGui().openContextMenu(panel);
        }
    }

    default public void closeContextMenu() {
        if (this instanceof Widget) {
            ((Widget)this).getGui().closeContextMenu();
        } else {
            this.openContextMenu(null);
        }
    }

    @Override
    default public void run() {
        if (ClientUtils.getCurrentGuiAs(IOpenableGui.class) != this) {
            this.openGui();
        }
    }

    default public Runnable openAfter(Runnable runnable) {
        return () -> {
            runnable.run();
            this.run();
        };
    }
}

