/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.utils;

import com.feed_the_beast.mods.ftbguilibrary.widget.CustomClickEvent;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.IGuiWrapper;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;

public class ClientUtils {
    public static final BooleanSupplier IS_CLIENT_OP = () -> Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_211513_k(1);
    public static final List<Runnable> RUN_LATER = new ArrayList<Runnable>();
    private static final MethodType EMPTY_METHOD_TYPE = MethodType.methodType(Void.TYPE);
    private static final HashMap<String, Optional<MethodHandle>> staticMethodCache = new HashMap();
    private static float lastBrightnessX;
    private static float lastBrightnessY;
    private static Boolean hasJavaFX;

    public static void pushBrightness(float u, float t) {
        lastBrightnessX = GlStateManager.lastBrightnessX;
        lastBrightnessY = GlStateManager.lastBrightnessY;
        RenderSystem.glMultiTexCoord2f((int)33985, (float)u, (float)t);
    }

    public static void pushMaxBrightness() {
        ClientUtils.pushBrightness(240.0f, 240.0f);
    }

    public static void popBrightness() {
        RenderSystem.glMultiTexCoord2f((int)33985, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static void execClientCommand(String command, boolean printChat) {
        if ((command = ForgeEventFactory.onClientSendMessage((String)command)).isEmpty()) {
            return;
        }
        if (printChat) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146239_a(command);
        }
        Minecraft.func_71410_x().field_71439_g.func_71165_d(command);
    }

    public static void runLater(Runnable runnable) {
        RUN_LATER.add(runnable);
    }

    @Nullable
    public static <T> T getGuiAs(Screen gui, Class<T> clazz) {
        GuiBase guiBase;
        if (gui instanceof IGuiWrapper && clazz.isAssignableFrom((guiBase = ((IGuiWrapper)gui).getGui()).getClass())) {
            return (T)guiBase;
        }
        return (T)(clazz.isAssignableFrom(gui.getClass()) ? Minecraft.func_71410_x().field_71462_r : null);
    }

    @Nullable
    public static <T> T getCurrentGuiAs(Class<T> clazz) {
        return Minecraft.func_71410_x().field_71462_r == null ? null : (T)ClientUtils.getGuiAs(Minecraft.func_71410_x().field_71462_r, clazz);
    }

    public static boolean hasJavaFX() {
        if (hasJavaFX == null) {
            try {
                Class.forName("javafx.scene.image.Image");
                hasJavaFX = true;
            }
            catch (Exception ex) {
                hasJavaFX = false;
            }
        }
        return hasJavaFX;
    }

    public static boolean handleClick(String scheme, String path) {
        switch (scheme) {
            case "http": 
            case "https": {
                try {
                    URI uri = new URI(scheme + ':' + path);
                    if (Minecraft.func_71410_x().field_71474_y.field_74358_q) {
                        Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
                        Minecraft.func_71410_x().func_147108_a((Screen)new ConfirmOpenLinkScreen(result -> {
                            if (result) {
                                try {
                                    Util.func_110647_a().func_195642_a(uri);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            Minecraft.func_71410_x().func_147108_a(currentScreen);
                        }, scheme + ':' + path, false));
                    } else {
                        Util.func_110647_a().func_195642_a(uri);
                    }
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case "file": {
                try {
                    Util.func_110647_a().func_195642_a(new URI("file:" + path));
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case "command": {
                ClientUtils.execClientCommand(path, false);
                return true;
            }
            case "static_method": {
                Optional<MethodHandle> handle = staticMethodCache.get(path);
                if (handle == null) {
                    handle = Optional.empty();
                    String[] s = path.split(":", 2);
                    try {
                        Class<?> c = Class.forName(s[0]);
                        MethodHandle h = MethodHandles.publicLookup().findStatic(c, s[1], EMPTY_METHOD_TYPE);
                        handle = Optional.ofNullable(h);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    staticMethodCache.put(path, handle);
                }
                if (handle.isPresent()) {
                    try {
                        handle.get().invoke();
                        return true;
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                return false;
            }
            case "custom": {
                return MinecraftForge.EVENT_BUS.post((Event)new CustomClickEvent(new ResourceLocation(path)));
            }
        }
        return MinecraftForge.EVENT_BUS.post((Event)new CustomClickEvent(new ResourceLocation(scheme, path)));
    }

    static {
        hasJavaFX = null;
    }
}

