/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.config.gui;

import com.feed_the_beast.mods.ftbguilibrary.config.ConfigCallback;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigList;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigValue;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfig;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.MutableColor4I;
import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.PanelScrollBar;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetLayout;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GuiEditConfigList<E, CV extends ConfigValue<E>>
extends GuiBase {
    private final ConfigList<E, CV> list;
    private final ConfigCallback callback;
    private final String title;
    private final Panel configPanel;
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final PanelScrollBar scroll;

    public GuiEditConfigList(ConfigList<E, CV> l, ConfigCallback cb) {
        this.list = l;
        this.callback = cb;
        this.title = TextFormatting.BOLD + this.list.getName();
        this.configPanel = new Panel(this){

            @Override
            public void addWidgets() {
                for (int i = 0; i < ((List)((GuiEditConfigList)GuiEditConfigList.this).list.value).size(); ++i) {
                    this.add(new ButtonConfigValue((Panel)this, GuiEditConfigList.this.list, i));
                }
                if (GuiEditConfigList.this.list.getCanEdit()) {
                    this.add(new ButtonAddValue(this));
                }
            }

            @Override
            public void alignWidgets() {
                for (Widget w : this.widgets) {
                    w.setWidth(this.width - 16);
                }
                GuiEditConfigList.this.scroll.setMaxValue(this.align(WidgetLayout.VERTICAL));
            }
        };
        this.scroll = new PanelScrollBar(this, this.configPanel);
        this.buttonAccept = new SimpleButton(this, I18n.func_135052_a((String)"gui.accept", (Object[])new Object[0]), GuiIcons.ACCEPT, (widget, button) -> this.callback.save(true));
        this.buttonCancel = new SimpleButton(this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), GuiIcons.CANCEL, (widget, button) -> this.callback.save(false));
    }

    @Override
    public boolean onInit() {
        return this.setFullscreen();
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        this.add(this.configPanel);
        this.add(this.scroll);
    }

    @Override
    public void alignWidgets() {
        this.configPanel.setPosAndSize(0, 20, this.width, this.height - 20);
        this.configPanel.alignWidgets();
        this.scroll.setPosAndSize(this.width - 16, 20, 16, this.height - 20);
        this.buttonAccept.setPos(this.width - 18, 2);
        this.buttonCancel.setPos(this.width - 38, 2);
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.buttonCancel.onClicked(MouseButton.LEFT);
        }
        return false;
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        GuiEditConfig.COLOR_BACKGROUND.draw(0, 0, w, 20);
        theme.drawString(this.getTitle(), 6, 6, 2);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Theme getTheme() {
        return GuiEditConfig.THEME;
    }

    public class ButtonAddValue
    extends Button {
        public ButtonAddValue(Panel panel) {
            super(panel);
            this.setHeight(12);
            this.setTitle("+ " + I18n.func_135052_a((String)"gui.add", (Object[])new Object[0]));
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            boolean mouseOver;
            boolean bl = mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            if (mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(x, y, w, h);
            }
            theme.drawString(this.getTitle(), x + 4, y + 2, theme.getContentColor(this.getWidgetType()), 2);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            ((ConfigValue)((GuiEditConfigList)GuiEditConfigList.this).list.type).value = ((ConfigValue)((GuiEditConfigList)GuiEditConfigList.this).list.type).defaultValue == null ? null : ((ConfigValue)((GuiEditConfigList)GuiEditConfigList.this).list.type).copy(((ConfigValue)((GuiEditConfigList)GuiEditConfigList.this).list.type).defaultValue);
            ((ConfigValue)((GuiEditConfigList)GuiEditConfigList.this).list.type).onClicked(button, accepted -> {
                if (accepted) {
                    ((List)((GuiEditConfigList)GuiEditConfigList.this).list.value).add(((ConfigValue)((GuiEditConfigList)GuiEditConfigList.this).list.type).value);
                }
                this.openGui();
            });
        }

        @Override
        public void addMouseOverText(List<String> list) {
        }
    }

    public static class ButtonConfigValue<E, CV extends ConfigValue<E>>
    extends Button {
        public final ConfigList<E, CV> list;
        public final int index;

        public ButtonConfigValue(Panel panel, ConfigList<E, CV> l, int i) {
            super(panel);
            this.list = l;
            this.index = i;
            this.setHeight(12);
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            boolean mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            MutableColor4I textCol = ((ConfigValue)this.list.type).getColor(((List)this.list.value).get(this.index)).mutable();
            textCol.setAlpha(255);
            if (mouseOver) {
                textCol.addBrightness(60);
                Color4I.WHITE.withAlpha(33).draw(x, y, w, h);
                if (this.getMouseX() >= x + w - 19) {
                    Color4I.WHITE.withAlpha(33).draw(x + w - 19, y, 19, h);
                }
            }
            theme.drawString(this.getGui().getTheme().trimStringToWidth(((ConfigValue)this.list.type).getStringForGUI(((List)this.list.value).get(this.index)), this.width), x + 4, y + 2, textCol, 0);
            if (mouseOver) {
                theme.drawString("[-]", x + w - 16, y + 2, Color4I.WHITE, 0);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            if (this.getMouseX() >= this.getX() + this.width - 19) {
                if (this.list.getCanEdit()) {
                    ((List)this.list.value).remove(this.index);
                    this.parent.refreshWidgets();
                }
            } else {
                ((ConfigValue)this.list.type).value = ((List)this.list.value).get(this.index);
                ((ConfigValue)this.list.type).onClicked(button, accepted -> {
                    if (accepted) {
                        ((List)this.list.value).set(this.index, ((ConfigValue)this.list.type).value);
                    }
                    this.openGui();
                });
            }
        }

        @Override
        public void addMouseOverText(List<String> l) {
            if (this.getMouseX() >= this.getX() + this.width - 19) {
                l.add(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]));
            } else {
                ((ConfigValue)this.list.type).value = ((List)this.list.value).get(this.index);
                ((ConfigValue)this.list.type).addInfo(l);
            }
        }
    }
}

