/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.entity;

import java.util.List;
import mekanism.additions.common.config.AdditionsCommonConfig;
import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.additions.common.entity.baby.EntityBabyStray;
import mekanism.additions.common.registries.AdditionsEntityTypes;
import mekanism.api.providers.IEntityTypeProvider;
import mekanism.common.Mekanism;
import mekanism.common.registration.impl.EntityTypeRegistryObject;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnHelper {
    public static void addSpawns() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            List monsterSpawns = biome.func_76747_a(EntityClassification.MONSTER);
            if (monsterSpawns.isEmpty()) continue;
            ResourceLocation biomeName = biome.getRegistryName();
            SpawnHelper.addSpawn(AdditionsEntityTypes.BABY_CREEPER, EntityType.field_200797_k, MekanismAdditionsConfig.common.babyCreeper, monsterSpawns, biomeName);
            SpawnHelper.addSpawn(AdditionsEntityTypes.BABY_ENDERMAN, EntityType.field_200803_q, MekanismAdditionsConfig.common.babyEnderman, monsterSpawns, biomeName);
            SpawnHelper.addSpawn(AdditionsEntityTypes.BABY_SKELETON, EntityType.field_200741_ag, MekanismAdditionsConfig.common.babySkeleton, monsterSpawns, biomeName);
            SpawnHelper.addSpawn(AdditionsEntityTypes.BABY_STRAY, EntityType.field_200750_ap, MekanismAdditionsConfig.common.babyStray, monsterSpawns, biomeName);
            SpawnHelper.addSpawn(AdditionsEntityTypes.BABY_WITHER_SKELETON, EntityType.field_200722_aA, MekanismAdditionsConfig.common.babyWitherSkeleton, monsterSpawns, biomeName);
        }
        SpawnHelper.addSpawn(AdditionsEntityTypes.BABY_WITHER_SKELETON, EntityType.field_200722_aA, MekanismAdditionsConfig.common.babyWitherSkeleton, Feature.field_202337_o.func_202279_e());
        SpawnHelper.registerSpawnControls(AdditionsEntityTypes.BABY_CREEPER, AdditionsEntityTypes.BABY_ENDERMAN, AdditionsEntityTypes.BABY_SKELETON, AdditionsEntityTypes.BABY_WITHER_SKELETON);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)AdditionsEntityTypes.BABY_STRAY.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityBabyStray::spawnRestrictions);
    }

    private static void addSpawn(IEntityTypeProvider entityTypeProvider, EntityType<?> parent, AdditionsCommonConfig.SpawnConfig spawnConfig, List<Biome.SpawnListEntry> monsterSpawns) {
        if (spawnConfig.shouldSpawn.get()) {
            monsterSpawns.stream().filter(monsterSpawn -> monsterSpawn.field_200702_b == parent).findFirst().ifPresent(parentEntry -> {
                EntityType entityType = entityTypeProvider.getEntityType();
                int weight = (int)Math.ceil((double)parentEntry.field_76292_a * spawnConfig.weightPercentage.get());
                int minSize = (int)Math.ceil((double)parentEntry.field_76301_c * spawnConfig.minSizePercentage.get());
                int maxSize = (int)Math.ceil((double)parentEntry.field_76299_d * spawnConfig.maxSizePercentage.get());
                monsterSpawns.add(new Biome.SpawnListEntry(entityType, weight, minSize, Math.max(minSize, maxSize)));
                Mekanism.logger.debug("Adding spawn rate for {} to nether bridges, with weight: {}, minSize: {}, maxSize: {}", (Object)entityType.getRegistryName(), (Object)weight, (Object)minSize, (Object)maxSize);
            });
        }
    }

    private static void addSpawn(IEntityTypeProvider entityTypeProvider, EntityType<?> parent, AdditionsCommonConfig.SpawnConfig spawnConfig, List<Biome.SpawnListEntry> monsterSpawns, ResourceLocation biomeName) {
        if (spawnConfig.shouldSpawn.get() && !((List)spawnConfig.biomeBlackList.get()).contains(biomeName)) {
            monsterSpawns.stream().filter(monsterSpawn -> monsterSpawn.field_200702_b == parent).findFirst().ifPresent(parentEntry -> {
                EntityType entityType = entityTypeProvider.getEntityType();
                int weight = (int)Math.ceil((double)parentEntry.field_76292_a * spawnConfig.weightPercentage.get());
                int minSize = (int)Math.ceil((double)parentEntry.field_76301_c * spawnConfig.minSizePercentage.get());
                int maxSize = (int)Math.ceil((double)parentEntry.field_76299_d * spawnConfig.maxSizePercentage.get());
                monsterSpawns.add(new Biome.SpawnListEntry(entityType, weight, minSize, Math.max(minSize, maxSize)));
                Mekanism.logger.debug("Adding spawn rate for {} in biome {}, with weight: {}, minSize: {}, maxSize: {}", (Object)entityType.getRegistryName(), (Object)biomeName, (Object)weight, (Object)minSize, (Object)maxSize);
            });
        }
    }

    @SafeVarargs
    private static void registerSpawnControls(EntityTypeRegistryObject<? extends MonsterEntity> ... entityTypeROs) {
        for (EntityTypeRegistryObject<? extends MonsterEntity> entityTypeRO : entityTypeROs) {
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)entityTypeRO.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        }
    }
}

