/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.shaded.hammerlib.api;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import tk.zeitheron.solarflux.SolarFlux;

public class OreDict {
    private static final Map<String, ResourceLocation> MAPPING = new HashMap<String, ResourceLocation>();
    private static boolean hasInit;

    public static void register(String key, String value) {
        OreDict.register(key, new ResourceLocation(value.contains(":") ? value : "forge:" + value));
    }

    public static void register(String key, Tag tag) {
        if (tag != null) {
            OreDict.register(key, tag.func_199886_b());
        }
    }

    public static void register(String key, ResourceLocation value) {
        MAPPING.put(key, value);
    }

    @Nullable
    public static ResourceLocation get(String od) {
        if (!MAPPING.containsKey(od)) {
            if (od.startsWith("ingot")) {
                MAPPING.put(od, new ResourceLocation("forge", "ingots/" + od.substring(5).toLowerCase()));
            }
            if (od.startsWith("ore")) {
                MAPPING.put(od, new ResourceLocation("forge", "ores/" + od.substring(3).toLowerCase()));
            }
            if (od.startsWith("gem")) {
                MAPPING.put(od, new ResourceLocation("forge", "gems/" + od.substring(3).toLowerCase()));
            }
            if (od.startsWith("block")) {
                MAPPING.put(od, new ResourceLocation("forge", "storage_blocks/" + od.substring(5).toLowerCase()));
            }
            if (od.startsWith("dust")) {
                MAPPING.put(od, new ResourceLocation("forge", "dusts/" + od.substring(4).toLowerCase()));
            }
            if (od.startsWith("gear")) {
                MAPPING.put(od, new ResourceLocation("forge", "gears/" + od.substring(4).toLowerCase()));
            }
            if (od.startsWith("plate")) {
                MAPPING.put(od, new ResourceLocation("forge", "plates/" + od.substring(5).toLowerCase()));
            }
            if (MAPPING.containsKey(od)) {
                SolarFlux.LOG.debug("Generated mapping for " + od + ": " + MAPPING.get(od));
            }
        }
        return MAPPING.get(od);
    }

    public static void initVanillaEntries() {
        if (!hasInit) {
            OreDict.register("logWood", ItemTags.field_200038_h);
            OreDict.register("plankWood", ItemTags.field_199905_b);
            OreDict.register("slabWood", ItemTags.field_202899_i);
            OreDict.register("stairWood", ItemTags.field_202898_h);
            OreDict.register("fenceWood", Tags.Items.FENCES_WOODEN);
            OreDict.register("fenceGateWood", Tags.Items.FENCE_GATES_WOODEN);
            OreDict.register("doorWood", ItemTags.field_200154_g);
            OreDict.register("stickWood", Tags.Items.RODS_WOODEN);
            OreDict.register("treeSapling", ItemTags.field_200037_g);
            OreDict.register("treeLeaves", ItemTags.field_206963_E);
            OreDict.register("oreGold", Tags.Items.ORES_GOLD);
            OreDict.register("oreIron", Tags.Items.ORES_IRON);
            OreDict.register("oreLapis", Tags.Items.ORES_LAPIS);
            OreDict.register("oreDiamond", Tags.Items.ORES_DIAMOND);
            OreDict.register("oreRedstone", Tags.Items.ORES_REDSTONE);
            OreDict.register("oreEmerald", Tags.Items.ORES_EMERALD);
            OreDict.register("oreQuartz", Tags.Items.ORES_QUARTZ);
            OreDict.register("oreCoal", Tags.Items.ORES_COAL);
            OreDict.register("ingotIron", Tags.Items.INGOTS_IRON);
            OreDict.register("ingotGold", Tags.Items.INGOTS_GOLD);
            OreDict.register("ingotBrick", Tags.Items.INGOTS_BRICK);
            OreDict.register("ingotBrickNether", Tags.Items.INGOTS_NETHER_BRICK);
            OreDict.register("nuggetIron", Tags.Items.NUGGETS_IRON);
            OreDict.register("nuggetIron", Tags.Items.NUGGETS_GOLD);
            OreDict.register("gemDiamond", Tags.Items.GEMS_DIAMOND);
            OreDict.register("gemEmerald", Tags.Items.GEMS_EMERALD);
            OreDict.register("gemQuartz", Tags.Items.GEMS_QUARTZ);
            OreDict.register("gemPrismarine", Tags.Items.GEMS_PRISMARINE);
            OreDict.register("gemLapis", Tags.Items.GEMS_LAPIS);
            OreDict.register("enderpearl", Tags.Items.ENDER_PEARLS);
            OreDict.register("dustPrismarine", Tags.Items.DUSTS_PRISMARINE);
            OreDict.register("dustRedstone", Tags.Items.DUSTS_REDSTONE);
            OreDict.register("dustGlowstone", Tags.Items.DUSTS_GLOWSTONE);
            OreDict.register("blockGold", Tags.Items.STORAGE_BLOCKS_GOLD);
            OreDict.register("blockIron", Tags.Items.STORAGE_BLOCKS_IRON);
            OreDict.register("blockLapis", Tags.Items.STORAGE_BLOCKS_LAPIS);
            OreDict.register("blockDiamond", Tags.Items.STORAGE_BLOCKS_DIAMOND);
            OreDict.register("blockRedstone", Tags.Items.STORAGE_BLOCKS_REDSTONE);
            OreDict.register("blockEmerald", Tags.Items.STORAGE_BLOCKS_EMERALD);
            OreDict.register("blockQuartz", Tags.Items.STORAGE_BLOCKS_QUARTZ);
            OreDict.register("blockCoal", Tags.Items.STORAGE_BLOCKS_COAL);
            OreDict.register("blockGlass", Tags.Items.GLASS);
            OreDict.register("dye", Tags.Items.DYES);
            OreDict.register("musicDisc", Tags.Items.MUSIC_DISCS);
            OreDict.register("stone", Tags.Items.STONE);
            OreDict.register("obsidian", Tags.Items.OBSIDIAN);
            OreDict.register("sand", ItemTags.field_203440_u);
            OreDict.register("brickStone", ItemTags.field_200033_c);
            OreDict.register("chest", Tags.Items.CHESTS);
            OreDict.register("chestWood", Tags.Items.CHESTS_WOODEN);
            OreDict.register("chestTrapped", Tags.Items.CHESTS_TRAPPED);
            OreDict.register("chestEnder", Tags.Items.CHESTS_ENDER);
        }
        hasInit = true;
    }

    static {
        OreDict.initVanillaEntries();
    }
}

