/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.proxy;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Locale;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.LanguageMap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import tk.zeitheron.solarflux.SolarFlux;
import tk.zeitheron.solarflux.block.SolarPanelBlock;
import tk.zeitheron.solarflux.client.SolarPanelBakedModel;
import tk.zeitheron.solarflux.client.screen.SolarPanelScreen;
import tk.zeitheron.solarflux.panels.SolarPanel;
import tk.zeitheron.solarflux.panels.SolarPanels;
import tk.zeitheron.solarflux.proxy.SFRCommonProxy;

public class SFRClientProxy
extends SFRCommonProxy {
    private Locale prevLocale;
    private Map<String, String> languageList;

    public SFRClientProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        ScreenManager.func_216911_a(SolarFlux.SOLAR_PANEL_CONTAINER, SolarPanelScreen::new);
    }

    @Override
    public void commonSetup() {
        super.commonSetup();
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent e) {
        if (this.languageList == null) {
            Field f = LanguageMap.class.getDeclaredFields()[3];
            f.setAccessible(true);
            try {
                this.languageList = (Map)f.get(LanguageMap.func_74808_a());
            }
            catch (IllegalAccessException ex) {
                this.languageList = new HashMap<String, String>();
                ex.printStackTrace();
            }
        }
        if (this.prevLocale != I18n.field_135054_a) {
            this.prevLocale = I18n.field_135054_a;
        }
        if (this.prevLocale != null) {
            Map[] langMaps;
            String lang = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
            for (Map langs : langMaps = new Map[]{this.prevLocale.field_135032_a, this.languageList}) {
                if (Objects.equals(langs.get("solarflux.langsapplied"), lang)) continue;
                langs.put("solarflux.langsapplied", lang);
                SolarPanels.listPanels().filter(SolarPanel::hasLang).forEach(p -> {
                    ResourceLocation path = p.getBlock().getRegistryName();
                    langs.put("block." + path.func_110624_b() + "." + path.func_110623_a(), p.getLang().getName(lang));
                });
            }
        }
    }

    @SubscribeEvent
    public void textureStitch(TextureStitchEvent.Pre e) {
        if (e.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            SolarPanels.listPanelBlocks().forEach(spb -> {
                e.addSprite(new ResourceLocation(spb.getRegistryName().func_110624_b(), "blocks/" + spb.getRegistryName().func_110623_a() + "_base"));
                e.addSprite(new ResourceLocation(spb.getRegistryName().func_110624_b(), "blocks/" + spb.getRegistryName().func_110623_a() + "_top"));
            });
        }
    }

    @SubscribeEvent
    public void modelBake(ModelBakeEvent e) {
        SolarPanels.listPanelBlocks().forEach(spb -> {
            IBakedModel cfr_ignored_0 = (IBakedModel)e.getModelRegistry().put(new ModelResourceLocation(spb.getRegistryName(), ""), new SolarPanelBakedModel((SolarPanelBlock)((Object)spb)));
        });
    }
}

