/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.items;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import tk.zeitheron.solarflux.block.SolarPanelTile;
import tk.zeitheron.solarflux.items.ItemTraversalUpgrade;
import tk.zeitheron.solarflux.items.ItemsSF;
import tk.zeitheron.solarflux.items.UpgradeItem;
import tk.zeitheron.solarflux.util.BlockPosFace;
import tk.zeitheron.solarflux.util.SimpleInventory;

public class ItemBlockChargingUpgrade
extends UpgradeItem {
    public ItemBlockChargingUpgrade() {
        super(1);
        this.setRegistryName("block_charging_upgrade");
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.func_77636_d(stack)) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_150297_b("Dim", 8)) {
                tooltip.add((ITextComponent)new StringTextComponent("Dimension: " + nbt.func_74779_i("Dim")));
            }
            tooltip.add((ITextComponent)new StringTextComponent("Facing: " + Direction.values()[nbt.func_74771_c("Face")]));
            BlockPos pos = BlockPos.func_218283_e((long)nbt.func_74763_f("Pos"));
            tooltip.add((ITextComponent)new StringTextComponent("X: " + pos.func_177958_n() + ", Y: " + pos.func_177956_o() + ", Z: " + pos.func_177952_p()));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity tile = context.func_195991_k().func_175625_s(context.func_195995_a());
        return tile != null ? (ActionResultType)tile.getCapability(CapabilityEnergy.ENERGY, context.func_196000_l()).filter(IEnergyStorage::canReceive).map(estorage -> {
            ItemStack held = context.func_195996_i();
            CompoundNBT nbt = held.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
                held.func_77982_d(nbt);
            }
            nbt.func_74778_a("Dim", context.func_195991_k().func_201675_m().func_186058_p().getRegistryName().toString());
            nbt.func_74772_a("Pos", context.func_195995_a().func_218275_a());
            nbt.func_74774_a("Face", (byte)context.func_196000_l().ordinal());
            estorage = null;
            context.func_195991_k().func_184133_a(null, context.func_195995_a(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 0.25f, 1.8f);
            return ActionResultType.SUCCESS;
        }).orElse((Object)ActionResultType.FAIL) : ActionResultType.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("Pos", 4) && stack.func_77978_p().func_150297_b("Face", 1);
    }

    @Override
    public boolean canInstall(SolarPanelTile tile, ItemStack stack, SimpleInventory upgradeInv) {
        TileEntity t;
        BlockPos pos;
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("Pos", 4) && stack.func_77978_p().func_150297_b("Face", 1) && (!stack.func_77978_p().func_150297_b("Dim", 8) || tile.func_145831_w().func_201675_m().func_186058_p().getRegistryName().toString().equals(stack.func_77978_p().func_74779_i("Dim"))) && tile.func_174877_v().func_177951_i((Vec3i)BlockPos.func_218283_e((long)stack.func_77978_p().func_74763_f("Pos"))) <= 256.0 && (pos = BlockPos.func_218283_e((long)stack.func_77978_p().func_74763_f("Pos"))) != null && (t = tile.func_145831_w().func_175625_s(pos)) != null && t.getCapability(CapabilityEnergy.ENERGY, Direction.values()[stack.func_77978_p().func_74771_c("Face")]).isPresent();
    }

    @Override
    public boolean canStayInPanel(SolarPanelTile tile, ItemStack stack, SimpleInventory upgradeInv) {
        return this.canInstall(tile, stack, upgradeInv);
    }

    @Override
    public void update(SolarPanelTile tile, ItemStack stack, int amount) {
        CompoundNBT nbt = stack.func_77978_p();
        if (tile.func_145831_w().func_72820_D() % 20L == 0L) {
            double d;
            BlockPos pos = BlockPos.func_218283_e((long)nbt.func_74763_f("Pos"));
            double d2 = tile.func_174877_v().func_177951_i((Vec3i)pos);
            if (d <= 256.0) {
                d2 /= 256.0;
                tile.traversal.clear();
                if (tile.getUpgrades(ItemsSF.TRAVERSAL_UPGRADE) > 0) {
                    ItemTraversalUpgrade.cache.clear();
                    ItemTraversalUpgrade.cache.add(pos);
                    ItemTraversalUpgrade.findMachines(tile, ItemTraversalUpgrade.cache, tile.traversal);
                }
                tile.traversal.add(new BlockPosFace(pos, Direction.values()[nbt.func_74771_c("Face")], (float)(1.0 - d2)));
            }
        }
    }
}

