/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.opengl.GL11;
import tk.zeitheron.solarflux.block.SolarPanelTile;
import tk.zeitheron.solarflux.container.SolarPanelContainer;
import tk.zeitheron.solarflux.util.ComplexProgressManager;

public class SolarPanelScreen
extends ContainerScreen<SolarPanelContainer> {
    private static final ResourceLocation ELEMENTS = new ResourceLocation("solarflux", "textures/gui/elements.png");
    private static final ResourceLocation TEXTURE = new ResourceLocation("solarflux", "textures/gui/solar.png");
    private static final int GAUGE_WIDTH = 18;
    private static final int GAUGE_HEIGHT = 50;
    private static final int GAUGE_INNER_WIDTH = 16;
    private static final int GAUGE_INNER_HEIGHT = 48;
    private static final int GAUGE_INNER_OFFSET_X = 1;
    private static final int GAUGE_INNER_OFFSET_Y = 1;
    private static final int GAUGE_SRC_X = 64;
    private static final int GAUGE_SRC_Y = 62;
    private static final int GAUGE_INNER_SRC_X = 0;
    private static final int GAUGE_INNER_SRC_Y = 64;
    private static final int BORDER_OFFSET = 8;
    public final SolarPanelTile solar;
    private final PlayerInventory pinv;
    public final ComplexProgressManager data;
    private List<String> tooltip = Lists.newArrayList();
    long energy;
    long capacity;
    long currentGeneration;
    long generation;
    float sunIntensity;

    public SolarPanelScreen(SolarPanelContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.data = screenContainer.progressHandler;
        this.pinv = inv;
        this.solar = screenContainer.panel;
        this.field_146999_f = 176;
        this.field_147000_g = 180;
    }

    public void tick() {
        this.energy = this.data.getLong(0);
        this.capacity = this.data.getLong(8);
        this.currentGeneration = this.data.getLong(16);
        this.generation = this.data.getLong(24);
        this.sunIntensity = this.data.getFloat(32);
        super.tick();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_227626_N_();
        this.font.func_211126_b(this.pinv.func_200200_C_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        this.font.func_211126_b(this.solar.func_195044_w().func_177230_c().func_200291_n().func_150254_d(), 8.0f, 4.0f, 0x404040);
        GL11.glTranslatef((float)8.0f, (float)14.0f, (float)0.0f);
        GL11.glScalef((float)0.9f, (float)0.9f, (float)0.9f);
        this.font.func_211126_b(I18n.func_135052_a((String)"info.solarflux.energy.stored1", (Object[])new Object[]{this.energy}), 0.0f, 0.0f, 0x404040);
        this.font.func_211126_b(I18n.func_135052_a((String)"info.solarflux.energy.capacity", (Object[])new Object[]{this.capacity}), 0.0f, 10.0f, 0x404040);
        this.font.func_211126_b(I18n.func_135052_a((String)"info.solarflux.energy.generation", (Object[])new Object[]{this.currentGeneration}), 0.0f, 20.0f, 0x404040);
        this.font.func_211126_b(I18n.func_135052_a((String)"info.solarflux.energy.efficiency", (Object[])new Object[]{this.generation > 0L ? Math.round(100.0 * (double)this.currentGeneration / (double)this.generation) : 0L}), 0.0f, 30.0f, 0x404040);
        GlStateManager.func_227627_O_();
        int x = this.field_146999_f - 18 - 8;
        int y = 40;
        boolean hover = this.inBounds(x + this.field_147003_i, y + this.field_147009_r, 18, 50, mouseX, mouseY);
        if (hover) {
            GL11.glDisable((int)3553);
            this.fillGradient(x + 1, y + 1, x + 18 - 1, y + 50 - 1, -1996488705, -1996488705);
            GL11.glEnable((int)3553);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(ELEMENTS);
            this.blit(x, y, 82, 62, 18, 50);
            if (this.pinv.func_70445_o().func_190926_b()) {
                this.drawMouseOver(I18n.func_135052_a((String)"info.solarflux.energy.stored2", (Object[])new Object[]{this.energy, this.capacity}));
            }
        }
        if (hover = this.inBounds((x = this.field_146999_f - 36 - 8 - 4) + this.field_147003_i, (y = 40) + this.field_147009_r, 18, 50, mouseX, mouseY)) {
            GL11.glDisable((int)3553);
            this.fillGradient(x + 1, y + 1, x + 18 - 1, y + 50 - 1, -1996488705, -1996488705);
            GL11.glEnable((int)3553);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(ELEMENTS);
            this.blit(x, y, 82, 62, 18, 50);
            if (this.pinv.func_70445_o().func_190926_b()) {
                this.drawMouseOver(I18n.func_135052_a((String)"info.solarflux.sun.intensity", (Object[])new Object[]{Math.round(100.0f * this.sunIntensity)}));
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        this.blit(xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
        this.minecraft.func_110434_K().func_110577_a(ELEMENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        this.drawPower(xStart + this.field_146999_f - 18 - 8, yStart + 8 + 32, mouseX, mouseY);
        this.drawSun(xStart + this.field_146999_f - 36 - 8 - 4, yStart + 8 + 32, mouseX, mouseY);
        for (int i = 0; i < this.solar.upgradeInventory.getSlots(); ++i) {
            this.blit(xStart + i * 18 + 8, yStart + 60, 18, 0, 18, 18);
        }
        this.blit(xStart + 150, yStart + 8, 18, 18, 18, 18);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        GlStateManager.func_227740_m_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.tooltip.clear();
        super.render(mouseX, mouseY, partialTicks);
        this.renderTooltip(this.tooltip, mouseX, mouseY, this.font);
        this.func_191948_b(mouseX, mouseY);
    }

    private void drawPower(int x, int y, int mx, int my) {
        this.blit(x + 1, y + 1, 16, 64, 16, 48);
        double height = (double)this.energy * 48.0 / (double)this.capacity;
        double offset = 48.0 - height;
        this.drawTMR(x + 1, (double)(y + 1) + offset, 0.0, 64.0 + offset, 16.0, height);
        this.blit(x, y, 64, 62, 18, 50);
    }

    private void drawSun(int x, int y, int mouseX, int mouseY) {
        this.blit(x + 1, y + 1, 48, 64, 16, 48);
        float height = 48.0f * this.sunIntensity;
        float offset = 48.0f - height;
        this.drawTMR(x + 1, (float)(y + 1) + offset, 32.0, 64.0f + offset, 16.0, height);
        this.blit(x, y, 64, 62, 18, 50);
    }

    public void drawTMR(double x, double y, double textureX, double textureY, double width, double height) {
        double zLevel = 0.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(x + 0.0, y + height, zLevel).func_225583_a_((float)(textureX + 0.0) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_(x + width, y + height, zLevel).func_225583_a_((float)(textureX + width) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_(x + width, y + 0.0, zLevel).func_225583_a_((float)(textureX + width) * 0.00390625f, (float)(textureY + 0.0) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_(x + 0.0, y + 0.0, zLevel).func_225583_a_((float)(textureX + 0.0) * 0.00390625f, (float)(textureY + 0.0) * 0.00390625f).func_181675_d();
        tessellator.func_78381_a();
    }

    public boolean inBounds(int x, int y, int w, int h, int mx, int my) {
        return mx >= x && mx < x + w && my >= y && my <= y + h;
    }

    public void drawMouseOver(String line) {
        if (line != null) {
            Collections.addAll(this.tooltip, line.split("\n"));
        }
    }
}

