/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import tk.zeitheron.solarflux.block.SolarPanelBlock;
import tk.zeitheron.solarflux.block.SolarPanelTile;

public class SolarPanelBakedModel
implements IDynamicBakedModel {
    public static final FaceBakery COOKER = new FaceBakery();
    public final SolarPanelBlock block;
    final ResourceLocation modelName = new ModelResourceLocation("solarflux", "solar_panel");
    public static final IModelTransform ZERO_SPRITE = new IModelTransform(){

        public boolean func_188049_c() {
            return false;
        }
    };
    final Function<ResourceLocation, TextureAtlasSprite> spriteGetter = Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_);
    ResourceLocation baseTx;
    ResourceLocation topTx;

    public SolarPanelBakedModel(SolarPanelBlock spb) {
        this.block = spb;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction sideIn, Random rand, IModelData extraData) {
        Direction[] sides;
        Direction[] directionArray;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (sideIn == null) {
            directionArray = Direction.values();
        } else {
            Direction[] directionArray2 = new Direction[1];
            directionArray = directionArray2;
            directionArray2[0] = sideIn;
        }
        for (Direction side : sides = directionArray) {
            if (side == null) continue;
            World world = (World)extraData.getData(SolarPanelTile.WORLD_PROP);
            BlockPos pos = (BlockPos)extraData.getData(SolarPanelTile.POS_PROP);
            TextureAtlasSprite top = this.t_top();
            TextureAtlasSprite base = this.t_base();
            float h = this.block.panel.getPanelData().height * 16.0f;
            quads.add(COOKER.func_228824_a_(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, h, 16.0f), new BlockPartFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, side.func_176740_k() == Direction.Axis.Y ? 0.0f : 16.0f - h, 16.0f, 16.0f}, 4)), side == Direction.UP ? top : base, side, ZERO_SPRITE, null, true, this.modelName));
            if (world == null || pos == null) {
                return quads;
            }
            boolean west = false;
            boolean east = false;
            boolean north = false;
            boolean south = false;
            west = world.func_180495_p(pos.func_177976_e()).func_177230_c() != this.block;
            if (west) {
                float[] fArray;
                Vector3f vector3f = new Vector3f(0.0f, h, 1.0f);
                Vector3f vector3f2 = new Vector3f(1.0f, h + 0.25f, 15.0f);
                if (side != Direction.UP) {
                    float[] fArray2 = new float[4];
                    fArray2[0] = 0.0f;
                    fArray2[1] = 0.0f;
                    fArray2[2] = 16.0f;
                    fArray = fArray2;
                    fArray2[3] = 1.0f;
                } else {
                    float[] fArray3 = new float[4];
                    fArray3[0] = 0.0f;
                    fArray3[1] = 0.0f;
                    fArray3[2] = 1.0f;
                    fArray = fArray3;
                    fArray3[3] = 16.0f;
                }
                quads.add(COOKER.func_228824_a_(vector3f, vector3f2, new BlockPartFace(null, 0, "#0", new BlockFaceUV(fArray, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
            }
            if (east = world.func_180495_p(pos.func_177974_f()).func_177230_c() != this.block) {
                float[] fArray;
                Vector3f vector3f = new Vector3f(15.0f, h, 1.0f);
                Vector3f vector3f3 = new Vector3f(16.0f, h + 0.25f, 15.0f);
                if (side != Direction.UP) {
                    float[] fArray4 = new float[4];
                    fArray4[0] = 0.0f;
                    fArray4[1] = 0.0f;
                    fArray4[2] = 16.0f;
                    fArray = fArray4;
                    fArray4[3] = 1.0f;
                } else {
                    float[] fArray5 = new float[4];
                    fArray5[0] = 15.0f;
                    fArray5[1] = 0.0f;
                    fArray5[2] = 16.0f;
                    fArray = fArray5;
                    fArray5[3] = 16.0f;
                }
                quads.add(COOKER.func_228824_a_(vector3f, vector3f3, new BlockPartFace(null, 0, "#0", new BlockFaceUV(fArray, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
            }
            if (north = world.func_180495_p(pos.func_177978_c()).func_177230_c() != this.block) {
                quads.add(COOKER.func_228824_a_(new Vector3f(1.0f, h, 0.0f), new Vector3f(15.0f, h + 0.25f, 1.0f), new BlockPartFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 1.0f}, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
            }
            if (south = world.func_180495_p(pos.func_177968_d()).func_177230_c() != this.block) {
                quads.add(COOKER.func_228824_a_(new Vector3f(1.0f, h, 15.0f), new Vector3f(15.0f, h + 0.25f, 16.0f), new BlockPartFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 1.0f}, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
            }
            if (west || north || world.func_180495_p(pos.func_177976_e().func_177978_c()).func_177230_c() != this.block) {
                quads.add(COOKER.func_228824_a_(new Vector3f(0.0f, h, 0.0f), new Vector3f(1.0f, h + 0.25f, 1.0f), new BlockPartFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 0.0f, 1.0f, 1.0f}, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
            }
            if (east || north || world.func_180495_p(pos.func_177974_f().func_177978_c()).func_177230_c() != this.block) {
                quads.add(COOKER.func_228824_a_(new Vector3f(15.0f, h, 0.0f), new Vector3f(16.0f, h + 0.25f, 1.0f), new BlockPartFace(null, 0, "#0", new BlockFaceUV(new float[]{15.0f, 0.0f, 16.0f, 1.0f}, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
            }
            if (south || east || world.func_180495_p(pos.func_177968_d().func_177974_f()).func_177230_c() != this.block) {
                quads.add(COOKER.func_228824_a_(new Vector3f(15.0f, h, 15.0f), new Vector3f(16.0f, h + 0.25f, 16.0f), new BlockPartFace(null, 0, "#0", new BlockFaceUV(new float[]{15.0f, 15.0f, 16.0f, 16.0f}, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
            }
            if (!west && !south && world.func_180495_p(pos.func_177976_e().func_177968_d()).func_177230_c() == this.block) continue;
            quads.add(COOKER.func_228824_a_(new Vector3f(0.0f, h, 15.0f), new Vector3f(1.0f, h + 0.25f, 16.0f), new BlockPartFace(null, 0, "#0", new BlockFaceUV(new float[]{0.0f, 15.0f, 1.0f, 16.0f}, 4)), base, side, ZERO_SPRITE, null, true, this.modelName));
        }
        return quads;
    }

    public ItemCameraTransforms func_177552_f() {
        return new ItemCameraTransforms(this.getTransform(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND), this.getTransform(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND), this.getTransform(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND), this.getTransform(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND), this.getTransform(ItemCameraTransforms.TransformType.HEAD), this.getTransform(ItemCameraTransforms.TransformType.GUI), this.getTransform(ItemCameraTransforms.TransformType.GROUND), this.getTransform(ItemCameraTransforms.TransformType.FIXED));
    }

    public ItemTransformVec3f getTransform(ItemCameraTransforms.TransformType type) {
        switch (type) {
            case GUI: {
                return new ItemTransformVec3f(new Vector3f(30.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f));
            }
        }
        return ItemTransformVec3f.field_178366_a;
    }

    public TextureAtlasSprite func_177554_e() {
        return ThreadLocalRandom.current().nextInt(5) > 0 ? this.t_base() : this.t_top();
    }

    public TextureAtlasSprite t_base() {
        if (this.baseTx == null) {
            this.baseTx = new ResourceLocation(this.block.getRegistryName().func_110624_b(), "blocks/" + this.block.getRegistryName().func_110623_a() + "_base");
        }
        return this.spriteGetter.apply(this.baseTx);
    }

    public TextureAtlasSprite t_top() {
        if (this.topTx == null) {
            this.topTx = new ResourceLocation(this.block.getRegistryName().func_110624_b(), "blocks/" + this.block.getRegistryName().func_110623_a() + "_top");
        }
        return this.spriteGetter.apply(this.topTx);
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

